/*
 * Decompiled with CFR 0.152.
 */
package jpalmdb.bitmap;

import java.awt.Color;
import jpalmdb.bitmap.AbstractBitmapFormat;

public class GrayBitmapFormat
extends AbstractBitmapFormat {
    private static final float RED_FACTOR = 0.3f;
    private static final float GREEN_FACTOR = 0.59f;
    private static final float BLUE_FACTOR = 0.11f;

    public GrayBitmapFormat(byte by) {
        super((byte)1, by);
    }

    public short getRowBytes(short s) {
        short s2 = (short)(s * this.depth / 8);
        if (s * this.depth % 8 != 0) {
            s2 = (short)(s2 + 1);
        }
        if (s2 % 2 == 1) {
            s2 = (short)(s2 + 1);
        }
        return s2;
    }

    public void addPixel(Color color) {
        if (this.offset >= this.rowwidth) {
            throw new IllegalStateException();
        }
        int n = this.offset * this.depth / 8;
        int n2 = this.offset * this.depth % 8;
        n2 = 8 - n2 - this.depth;
        byte by = this.getPixelFromColor(color);
        int n3 = n;
        this.row[n3] = (byte)(this.row[n3] | by << n2);
        ++this.offset;
    }

    public Color getPixel() {
        int n = this.offset * this.depth / 8;
        int n2 = this.offset * this.depth % 8;
        n2 = 8 - n2 - this.depth;
        int n3 = this.row[n] >> n2;
        n3 &= (1 << this.depth) - 1;
        n3 = n3 * 255 / ((1 << this.depth) - 1);
        n3 = 255 - n3;
        ++this.offset;
        return new Color(n3, n3, n3);
    }

    protected byte getPixelFromColor(Color color) {
        float f = (float)color.getRed() * 0.3f + (float)color.getGreen() * 0.59f + (float)color.getBlue() * 0.11f;
        int n = Math.round((f = 255.0f - f) * (float)((1 << this.depth) - 1) / 255.0f);
        if (n >= 1 << this.depth || n < 0) {
            throw new RuntimeException();
        }
        return (byte)n;
    }
}

