/*
 * Decompiled with CFR 0.152.
 */
package parserutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class CSVReader {
    private final BufferedReader br;
    private char separator = '\u0000';

    public CSVReader(BufferedReader bufferedReader) {
        this.br = bufferedReader;
    }

    public CSVReader(Reader reader) {
        this(new BufferedReader(reader));
    }

    public CSVReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, string));
    }

    public void close() throws IOException {
        this.br.close();
    }

    public String[] read() throws IOException {
        String string = this.br.readLine();
        if (string == null) {
            return null;
        }
        while (string.startsWith("#") || string.length() == 0) {
            string = this.br.readLine();
        }
        if (this.separator == '\u0000') {
            this.separator = string.indexOf(59) != -1 ? (char)59 : (string.indexOf(44) != -1 ? (char)44 : (char)59);
        }
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string != null) {
            if (string.startsWith("\"")) {
                String string3 = "";
                while (true) {
                    int n;
                    if ((n = string.indexOf("\"", 1)) == -1) {
                        throw new IOException("Unparsable CSV line: " + string2);
                    }
                    string3 = string3 + string.substring(1, n);
                    if ((string = string.substring(n + 1)).length() == 0) {
                        string = null;
                        break;
                    }
                    if (string.charAt(0) == this.separator) {
                        string = string.substring(1);
                        break;
                    }
                    if (string.charAt(0) != '\"') {
                        throw new IOException("Unparsable CSV line: " + string2 + "\nat: " + string);
                    }
                    string3 = string3 + "\"";
                }
                arrayList.add(string3);
                continue;
            }
            int n = string.indexOf(this.separator);
            if (n == -1) {
                arrayList.add(string);
                string = null;
                continue;
            }
            arrayList.add(string.substring(0, n));
            string = string.substring(n + 1);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

