/*
 * Decompiled with CFR 0.152.
 */
package parserutil;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVWriter {
    private Writer w;
    private char separator = (char)59;

    public CSVWriter(Writer writer) {
        this.w = writer;
    }

    public CSVWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, string));
    }

    public void flush() throws IOException {
        this.w.flush();
    }

    public void close() throws IOException {
        this.w.close();
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char c) {
        this.separator = c;
    }

    public void write(String ... stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                this.w.write(this.separator);
            }
            this.w.write("\"" + stringArray[i].replaceAll("\"", "\"\"") + "\"");
        }
        this.w.write("\r\n");
    }

    public void write(Map<String, String> map, String[] stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = map.get(stringArray[i]);
            if (string == null) {
                string = "";
            }
            stringArray2[i] = string;
        }
        this.write(stringArray2);
    }
}

