/*
 * Decompiled with CFR 0.152.
 */
package pzdb;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import jpalmdb.bitmap.BitmapEncoder;
import jpalmdb.bitmap.BitmapFormat;
import jpalmdb.bitmap.ColorBitmapFormat;
import jpalmdb.bitmap.GrayBitmapFormat;
import jpalmdb.bitmap.Version0BitmapFormat;
import parserutil.CSVWriter;
import pzdb.PZDBInputStream;
import pzdb.PZDBRecord;

public class PZDBDecoder {
    private final File pzdbFile;

    public PZDBDecoder(File file) {
        this.pzdbFile = file;
    }

    public void dump(File file) throws IOException {
        int n;
        PZDBInputStream pZDBInputStream = new PZDBInputStream(this.pzdbFile);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = pZDBInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
    }

    public void decode(File file) throws IOException {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        int n2;
        PZDBInputStream pZDBInputStream = new PZDBInputStream(this.pzdbFile);
        DataInputStream dataInputStream = new DataInputStream(pZDBInputStream);
        int n3 = dataInputStream.readByte() & 0xFF;
        byte[] byArray = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = dataInputStream.readByte();
            dataInputStream.readByte();
        }
        n2 = 2 * n3 + 1;
        ArrayList<PZDBRecord> arrayList = new ArrayList<PZDBRecord>();
        while (true) {
            int n4 = dataInputStream.readByte() & 0xFF;
            ++n2;
            if (n4 == 0) break;
            PZDBRecord pZDBRecord = new PZDBRecord(dataInputStream, n4, n3);
            n2 += n4;
            arrayList.add(pZDBRecord);
        }
        for (PZDBRecord pZDBRecord : arrayList) {
            object4 = pZDBRecord.getLongMemoOffsetAndLength();
            if (object4 == null) continue;
            while (object4[0] > n2) {
                System.out.println("Ignored a byte");
                dataInputStream.read();
                ++n2;
            }
            if (object4[0] < n2) {
                throw new IOException("Overlapping long memos");
            }
            object3 = new byte[object4[1]];
            dataInputStream.readFully((byte[])object3);
            n2 += object4[1];
            pZDBRecord.setLongMemo((byte[])object3);
        }
        if (dataInputStream.read() != -1) {
            throw new IOException("Not at EOF");
        }
        dataInputStream.close();
        boolean bl = false;
        int n5 = 0;
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            object3 = (PZDBRecord)object4.next();
            n = ((PZDBRecord)object3).parseMap();
            if (n == -1) {
                bl = true;
                n = 1;
            }
            if (n <= n5) continue;
            n5 = n;
        }
        object4 = new boolean[n5];
        for (int i = 1; i <= n5; ++i) {
            dataInputStream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(pZDBInputStream.getPDBFile().getRecord(pZDBInputStream.getPDBFile().getRecordCount() - i).getData())));
            n = dataInputStream.readShort();
            byte[] object5 = new byte[n];
            dataInputStream.readFully(object5);
            if (dataInputStream.read() != -1) {
                throw new IOException();
            }
            dataInputStream.close();
            if (object5[8] == 16) {
                object4[i - 1] = 1;
                object2 = new ColorBitmapFormat();
            } else if (object5[8] == 0) {
                object2 = new Version0BitmapFormat();
            } else if (object5[8] == 1 || object5[8] == 2 || object5[8] == 4) {
                object2 = new GrayBitmapFormat(object5[8]);
            } else {
                throw new IOException("Unknown bitmap format");
            }
            object = new BitmapEncoder((BitmapFormat)object2).decode(object5);
            File file2 = new File(file.getAbsolutePath() + ".image" + i + ".png");
            ImageIO.write((RenderedImage)object, "png", file2);
            System.out.println("Saved image " + i);
        }
        CSVWriter cSVWriter = new CSVWriter(new FileWriter(file));
        for (PZDBRecord pZDBRecord : arrayList) {
            object2 = new ArrayList<String>();
            object = pZDBRecord.getColumns();
            if (byArray != null) {
                if (((String[])object).length != byArray.length) {
                    throw new IOException(((String[])object).length + " != " + byArray.length);
                }
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = (byArray[i] & 0xFF) + ":" + object[i];
                }
            }
            ((ArrayList)object2).addAll(Arrays.asList(object));
            if (byArray != null) {
                if (bl) {
                    ((ArrayList)object2).add((object4[0] != 0 ? "CM=" : "M=") + file.getName() + ".image1.png");
                }
                byArray = null;
            }
            ((ArrayList)object2).addAll(pZDBRecord.getExtras((boolean[])object4, file.getName() + ".image"));
            cSVWriter.write(((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]));
        }
        cSVWriter.flush();
        cSVWriter.close();
    }
}

