/*
 * Decompiled with CFR 0.152.
 */
package pzdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import parserutil.CSVReader;
import pzdb.PZDBOutputStream;
import pzdb.PZDBRecord;

public class PZDBEncoder {
    public final File csvFile;
    public static final byte[] CREATOR = new byte[]{100, 97, 116, 97, 112, 122, 68, 66};

    public PZDBEncoder(File file) {
        this.csvFile = file;
    }

    public void encode() throws IOException {
        String string = this.csvFile.getAbsolutePath();
        if (string.endsWith(".csv")) {
            string = string.substring(0, string.length() - 4);
        }
        this.encode(string, new File(this.csvFile.getParent(), string + ".pdb"));
    }

    public void encode(String string, File file) throws IOException {
        this.encode(string, file, new Date());
    }

    public void encode(String string, File file, Date date) throws IOException {
        int n;
        Object object;
        String[] stringArray;
        Object object2;
        int n2;
        int n3;
        String[] stringArray2;
        Object object3;
        PZDBOutputStream pZDBOutputStream = new PZDBOutputStream();
        File file2 = this.csvFile.getParentFile();
        ArrayList<PZDBRecord> arrayList = new ArrayList<PZDBRecord>();
        CSVReader cSVReader = new CSVReader(new FileReader(this.csvFile));
        boolean bl = false;
        Object[] objectArray = cSVReader.read();
        String[] stringArray3 = new String[]{};
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].charAt(0) <= '9' && objectArray[i].charAt(0) >= '0') continue;
            stringArray3 = new String[objectArray.length - i];
            object3 = new String[i];
            System.arraycopy(objectArray, 0, object3, 0, ((byte[])object3).length);
            System.arraycopy(objectArray, ((byte[])object3).length, stringArray3, 0, stringArray3.length);
            objectArray = (Object[])object3;
            break;
        }
        byte[] byArray = new byte[objectArray.length];
        object3 = new byte[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray2 = objectArray[i];
            n3 = stringArray2.indexOf(":");
            if (n3 == -1) {
                throw new RuntimeException();
            }
            n2 = Integer.parseInt(stringArray2.substring(0, n3));
            if (n2 < 0) {
                throw new RuntimeException("Column width must be positive");
            }
            if (n2 > 150) {
                throw new RuntimeException("Column width too high");
            }
            if (n2 > 0 && i >= 8) {
                throw new RuntimeException("Only 8 visible columns supported");
            }
            byArray[i] = (byte)n2;
            if (i > 0 && byArray[i] != 0 && byArray[i - 1] == 0) {
                System.out.println("*** WARNING: All visible columns should be left of all invisible columns! ***");
            }
            objectArray[i] = stringArray2.substring(n3 + 1);
        }
        PZDBRecord pZDBRecord = new PZDBRecord(file2, (String[])objectArray);
        stringArray2 = stringArray3;
        n3 = stringArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = stringArray2[n2];
            if (string2.startsWith("M=")) {
                if (pZDBOutputStream.getImageRecordCount() != 0) {
                    throw new IOException("Map must be the first image");
                }
                bl = true;
                pZDBOutputStream.addImageRecord(file2, string2.substring(2), false);
                continue;
            }
            if (string2.startsWith("CM=")) {
                if (pZDBOutputStream.getImageRecordCount() != 0) {
                    throw new IOException("Map must be the first image");
                }
                bl = true;
                pZDBOutputStream.addImageRecord(file2, string2.substring(3), true);
                continue;
            }
            pZDBRecord.parseExtra(string2, pZDBOutputStream, false);
        }
        pZDBRecord.updateMaxLengths((byte[])object3);
        arrayList.add(pZDBRecord);
        while ((stringArray2 = cSVReader.read()) != null) {
            if (stringArray2.length < byArray.length) {
                throw new IOException("Too few columns: " + PZDBEncoder.makeErrorString(stringArray2));
            }
            String[] stringArray4 = new String[byArray.length];
            System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray4.length);
            PZDBRecord pZDBRecord2 = new PZDBRecord(file2, stringArray4);
            for (int i = stringArray4.length; i < stringArray2.length; ++i) {
                pZDBRecord2.parseExtra(stringArray2[i], pZDBOutputStream, bl);
            }
            pZDBRecord2.updateMaxLengths((byte[])object3);
            arrayList.add(pZDBRecord2);
        }
        cSVReader.close();
        if (arrayList.size() > 65535) {
            throw new RuntimeException("Too many records!");
        }
        boolean bl2 = false;
        for (PZDBRecord pZDBRecord3 : arrayList) {
            bl2 |= pZDBRecord3.finish();
        }
        if (bl2) {
            int n4 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] <= 0) continue;
                n4 = i + 1;
            }
            if (n4 == byArray.length) {
                throw new IOException("Records too long");
            }
            byte[] byArray2 = new byte[n4];
            object2 = new byte[n4];
            stringArray = new String[byArray.length - n4];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(object3, 0, object2, 0, ((Object)object2).length);
            object3 = object2;
            byArray = byArray2;
            System.arraycopy(((PZDBRecord)arrayList.get(0)).getColumns(), n4, stringArray, 0, stringArray.length);
            boolean bl3 = true;
            Iterator object4 = arrayList.iterator();
            while (object4.hasNext()) {
                object = (PZDBRecord)object4.next();
                object.ShiftColumns(stringArray, bl3);
                bl3 = false;
            }
        }
        int n5 = byArray.length * 2 + 1 + 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (PZDBRecord)iterator.next();
            int n6 = ((PZDBRecord)object2).getRecordLength();
            if (n6 > 255) {
                throw new IOException("Record too long: " + object2);
            }
            n5 += n6 + 1;
        }
        int n7 = n5;
        System.out.println("Encoding " + arrayList.size() + " records...");
        pZDBOutputStream.write(byArray.length);
        for (n = 0; n < byArray.length; ++n) {
            System.out.println("Column " + (n + 1) + " max length: " + (object3[n] & 0xFF));
            pZDBOutputStream.write(new byte[]{byArray[n], object3[n]});
        }
        n = 0;
        stringArray = new ByteArrayOutputStream();
        for (PZDBRecord pZDBRecord2 : arrayList) {
            object = pZDBRecord2.getLongMemo(n7);
            if (object != null) {
                n = 1;
                if (((byte[])object).length > Short.MAX_VALUE) {
                    throw new IOException("LongMemo too long: " + ((Object)object).length);
                }
                stringArray.write((byte[])object);
                n7 += ((Object)object).length;
            }
            pZDBRecord2.writeRecord(pZDBOutputStream);
        }
        Object object5 = "";
        if (n != 0) {
            object5 = (String)object5 + "CONFIG_LONG_MEMO ";
        }
        if (bl) {
            object5 = (String)object5 + "CONFIG_MAPMARK ";
        }
        if (pZDBOutputStream.getImageRecordCount() > 1 || !bl && pZDBOutputStream.getImageRecordCount() > 0) {
            object5 = (String)object5 + "CONFIG_IMAGE ";
        }
        if (((String)object5).length() == 0) {
            object5 = "None";
        }
        pZDBOutputStream.write(0);
        stringArray.close();
        if (pZDBOutputStream.getUncompressedLength() != n5) {
            throw new IOException("Error in length calculation: " + pZDBOutputStream.getUncompressedLength() + " != " + n5);
        }
        pZDBOutputStream.write(stringArray.toByteArray());
        if (pZDBOutputStream.getUncompressedLength() != n7) {
            throw new IOException("Error in length calculation: " + pZDBOutputStream.getUncompressedLength() + " != " + n7);
        }
        pZDBOutputStream.close();
        pZDBOutputStream.toPDBFile(file, "pzDB" + string, CREATOR, date);
        System.out.println("================================================\n Finished writing " + file.getName() + "\n" + "   Compressed size:    " + file.length() + "\n" + "   Uncompressed size:  " + n7 + "\n" + "   Required DB format extensions: " + (String)object5 + "\n" + "================================================");
    }

    public static String makeErrorString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append("\"" + stringArray[i].replaceAll("\"", "\"\"") + "\"");
        }
        return stringBuffer.toString();
    }
}

