/*
 * Decompiled with CFR 0.152.
 */
package pzdb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.InflaterInputStream;
import jpalmdb.PDBFile;

public class PZDBInputStream
extends InputStream {
    private InputStream in;
    private PDBFile pf;

    public PZDBInputStream(File file) throws IOException {
        this.pf = new PDBFile(file);
        if (this.pf.getVersion() != 1 && !this.pf.getTypeAndCreator().equals("datapzDB")) {
            throw new IOException("Unsupported format");
        }
        this.in = new ByteArrayInputStream(this.pf.getRecord(0).getData());
        for (int i = 1; i < this.pf.getRecordCount(); ++i) {
            this.in = new SequenceInputStream(this.in, new ByteArrayInputStream(this.pf.getRecord(i).getData()));
        }
        this.in = new InflaterInputStream(this.in);
    }

    public PDBFile getPDBFile() {
        return this.pf;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

