/*
 * Decompiled with CFR 0.152.
 */
package pzdb;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;
import jpalmdb.PDBFile;
import jpalmdb.bitmap.AbstractBitmapFormat;
import jpalmdb.bitmap.BitmapEncoder;
import jpalmdb.bitmap.ColorBitmapFormat;
import jpalmdb.bitmap.GrayBitmapFormat;
import jpalmdb.bitmap.Version0BitmapFormat;

public class PZDBOutputStream
extends OutputStream {
    private static final int CHUNKSIZE = 32768;
    private final DeflaterOutputStream stream;
    private final ByteArrayOutputStream baos;
    private int len = 0;
    private final List<byte[]> imageRecords = new ArrayList<byte[]>();

    public PZDBOutputStream() {
        this.baos = new ByteArrayOutputStream();
        this.stream = new DeflaterOutputStream(this.baos);
    }

    public void addImageRecord(File file, String string, boolean bl) throws IOException {
        AbstractBitmapFormat abstractBitmapFormat;
        Object object;
        System.out.println("Converting image: " + string);
        BufferedImage bufferedImage = ImageIO.read(new File(file, string));
        if (bufferedImage.getWidth() > 150 || bufferedImage.getHeight() > 130) {
            throw new IOException("Image too large");
        }
        boolean bl2 = true;
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                object = new Color(bufferedImage.getRGB(j, i));
                if (((Color)object).equals(Color.WHITE) || ((Color)object).equals(Color.BLACK)) continue;
                bl2 = false;
            }
        }
        if (bl2) {
            abstractBitmapFormat = new Version0BitmapFormat();
            System.out.println("Format: Black&White");
        } else if (bl) {
            abstractBitmapFormat = new ColorBitmapFormat();
            System.out.println("Format: Color");
        } else {
            abstractBitmapFormat = new GrayBitmapFormat(4);
            System.out.println("Format: 4-bit Gray");
        }
        BitmapEncoder bitmapEncoder = new BitmapEncoder(abstractBitmapFormat);
        object = bitmapEncoder.encode(bufferedImage);
        BufferedImage bufferedImage2 = bitmapEncoder.decode((byte[])object);
        byte[] byArray = bitmapEncoder.encode(bufferedImage2);
        if (!Arrays.equals((byte[])object, byArray)) {
            throw new RuntimeException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(new DeflaterOutputStream(byteArrayOutputStream));
        System.out.println("Uncompressed image size: " + ((Object)object).length);
        dataOutputStream.writeShort(((Object)object).length);
        dataOutputStream.write((byte[])object);
        dataOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.out.println("Compressed image size: " + byArray2.length);
        if (byArray2.length > 32768) {
            throw new IllegalArgumentException();
        }
        this.imageRecords.add(0, byArray2);
    }

    public void write(int n) throws IOException {
        this.stream.write(n);
        ++this.len;
    }

    public void write(byte[] byArray) throws IOException {
        this.stream.write(byArray);
        this.len += byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.stream.write(byArray, n, n2);
        this.len += n2;
    }

    public void toPDBFile(File file, String string, byte[] byArray, Date date) throws IOException {
        this.stream.finish();
        byte[] byArray2 = this.baos.toByteArray();
        PDBFile pDBFile = new PDBFile(string, byArray, 1, date, date, date);
        pDBFile.addRecords(byArray2, 32768);
        if (this.imageRecords != null) {
            for (byte[] byArray3 : this.imageRecords) {
                pDBFile.addRecord(byArray3);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        pDBFile.generate(fileOutputStream);
        fileOutputStream.close();
    }

    public int getUncompressedLength() {
        return this.len;
    }

    public int getImageRecordCount() {
        return this.imageRecords.size();
    }
}

