/*
 * Decompiled with CFR 0.152.
 */
package pzdb;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pzdb.PZDBEncoder;
import pzdb.PZDBOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PZDBRecord {
    private final File directory;
    private String[] columns;
    private StringBuffer extraData;
    byte[] extra = null;
    private int mapX = -1;
    private int mapY = -1;
    boolean makeLongMemo;

    public PZDBRecord(File file, String[] stringArray) {
        this.columns = stringArray;
        this.directory = file;
        this.extraData = new StringBuffer();
    }

    public PZDBRecord(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.directory = null;
        this.columns = new String[n2];
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (n == 0) {
                throw new IOException("Too few columns in record");
            }
            byte by = dataInputStream.readByte();
            --n;
            if (by == 0) {
                this.columns[n3++] = stringBuffer.toString();
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append((char)(by & 0xFF));
        }
        this.extra = new byte[n];
        dataInputStream.readFully(this.extra);
    }

    public void parseExtra(String string, PZDBOutputStream pZDBOutputStream, boolean bl) throws IOException {
        if (string.startsWith("F=")) {
            this.extraData.append(this.loadMemo(string.substring(2)));
        } else if (string.startsWith("T=")) {
            this.extraData.append("\n" + string.substring(2));
        } else if (string.startsWith("I=") || string.startsWith("P=")) {
            pZDBOutputStream.addImageRecord(this.directory, string.substring(2), string.startsWith("P="));
            this.mapX = 254;
            this.mapY = pZDBOutputStream.getImageRecordCount();
            if (this.mapY > 255) {
                throw new IOException("Too many images embedded");
            }
        } else if (string.startsWith("C=")) {
            if (!bl) {
                throw new IOException("No map present for coordinates: " + string);
            }
            Matcher matcher = Pattern.compile("C=([0-9]+),([0-9]+)").matcher(string);
            if (!matcher.matches()) {
                throw new RuntimeException(string);
            }
            this.mapX = Integer.parseInt(matcher.group(1));
            this.mapY = Integer.parseInt(matcher.group(2));
            if (this.mapX < 0 || this.mapX > 253) {
                throw new IOException("X coordinate out of range: " + string);
            }
            if (this.mapY < 0 || this.mapY > 255) {
                throw new IOException("Y coordinate out of range: " + string);
            }
        } else {
            throw new IOException("Unknown Extra field: " + string);
        }
    }

    private String loadMemo(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.directory, string)));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append('\n');
            stringBuffer.append(string2);
        }
        bufferedReader.close();
        if (stringBuffer.length() > Short.MAX_VALUE) {
            throw new IOException("Memo too long: " + string);
        }
        return stringBuffer.toString();
    }

    public void updateMaxLengths(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (this.columns[i].length() > 255) {
                throw new RuntimeException();
            }
            if ((byArray[i] & 0xFF) > this.columns[i].length()) continue;
            byArray[i] = (byte)(this.columns[i].length() + 1);
        }
    }

    public boolean finish() throws IOException {
        if (this.extraData.length() > 0) {
            this.extraData.delete(0, 1);
        }
        if (this.mapX != -1) {
            this.extraData.append("\u0000\u0000" + (char)this.mapX + "" + (char)this.mapY);
        }
        this.extra = this.extraData.toString().getBytes("ISO-8859-1");
        this.extraData = null;
        int n = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            n += this.columns[i].length() + 1;
        }
        if (n + this.extra.length > 255) {
            this.makeLongMemo = true;
        }
        return this.getRecordLength() > 255;
    }

    public int getRecordLength() {
        int n = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            n += this.columns[i].length() + 1;
        }
        n = this.makeLongMemo ? (n += 8) : (n += this.extra.length);
        return n;
    }

    public byte[] getLongMemo(int n) throws IOException {
        if (!this.makeLongMemo) {
            return null;
        }
        byte[] byArray = this.extra;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(new byte[2]);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.close();
        this.extra = byteArrayOutputStream.toByteArray();
        this.makeLongMemo = false;
        return byArray;
    }

    public void writeRecord(PZDBOutputStream pZDBOutputStream) throws IOException {
        if (this.makeLongMemo) {
            throw new RuntimeException();
        }
        pZDBOutputStream.write(this.getRecordLength());
        for (int i = 0; i < this.columns.length; ++i) {
            pZDBOutputStream.write(this.columns[i].getBytes("ISO-8859-1"));
            pZDBOutputStream.write(0);
        }
        pZDBOutputStream.write(this.extra);
    }

    public void ShiftColumns(String[] stringArray, boolean bl) throws IOException {
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = i + this.columns.length - stringArray.length;
                if (this.columns[n].equals(stringArray[i])) continue;
                throw new RuntimeException();
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < stringArray.length; ++i) {
                int n = i + this.columns.length - stringArray.length;
                String string = stringArray[i] + ": " + this.columns[n] + "\n";
                byteArrayOutputStream.write(string.getBytes("ISO-8859-1"));
            }
            byteArrayOutputStream.write(this.extra);
            this.extra = byteArrayOutputStream.toByteArray();
        }
        String[] stringArray2 = new String[this.columns.length - stringArray.length];
        System.arraycopy(this.columns, 0, stringArray2, 0, stringArray2.length);
        this.columns = stringArray2;
        if (this.getRecordLength() > 255) {
            this.makeLongMemo = true;
        }
    }

    public int[] getLongMemoOffsetAndLength() throws IOException {
        if (this.extra.length != 8 || this.extra[0] != 0 || this.extra[1] != 0) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.extra));
        dataInputStream.readShort();
        int n = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        if (dataInputStream.read() != -1) {
            throw new IOException();
        }
        dataInputStream.close();
        return new int[]{n, s};
    }

    public void setLongMemo(byte[] byArray) {
        this.extra = byArray;
        this.makeLongMemo = true;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int parseMap() {
        int n = this.extra.length;
        if (this.extra.length >= 4 && this.extra[n - 4] == 0 && this.extra[n - 3] == 0) {
            this.mapX = this.extra[n - 2] & 0xFF;
            this.mapY = this.extra[n - 1] & 0xFF;
            byte[] byArray = new byte[n - 4];
            System.arraycopy(this.extra, 0, byArray, 0, n - 4);
            this.extra = byArray;
            return this.mapX == 254 ? this.mapY : -1;
        }
        return 0;
    }

    public List<String> getExtras(boolean[] blArray, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mapX == 254) {
            arrayList.add((blArray[this.mapY - 1] ? "P=" : "I=") + string + this.mapY + ".png");
        } else if (this.mapX != -1) {
            arrayList.add("C=" + this.mapX + "," + this.mapY);
        }
        for (String string2 : stringArray = new String(this.extra).split("\n", -1)) {
            arrayList.add("T=" + string2);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PZDBEncoder.makeErrorString(this.columns));
        stringBuffer.append("::");
        if (this.extra != null) {
            stringBuffer.append(new String(this.extra));
        } else {
            stringBuffer.append(this.extraData);
            if (this.mapX != -1) {
                stringBuffer.append("::" + this.mapX + "," + this.mapY);
            }
        }
        return stringBuffer.toString();
    }
}

