//  Copyright (C) 2004 PocketDOS
//
//    PocketDOS
//    http://www.pocketdos.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


#ifndef _BOCHS_CPU_H
#define _BOCHS_CPU_H

#include "stdafx.h"
#include <stdlib.h>
#include "bochs.h"
#include "CPU86_Interface.h"

// Usually defined in bochs.h
#define A20ADDR(x)						((x) & theCPU.dwAddressMask)
#define BX_TICK1()						BX_TICKN( 1 )
#define BX_HRQ							0
#define BX_INP(addr, len)				BOCHS_ReadPort(addr, len)
#define BX_OUTP(addr, val, len)			BOCHS_WritePort(addr, val, len)
#define BX_TICKN(n)						BOCHS_Tick(n)
#define BX_CPU_SYSREQ					theCPU.bSysReqPending
#define	BX_SYSREQ()						(*theCPU.pInterface->sSys.pfnSysReq)()

// Usually defined in plugin.h
#define DEV_dma_raise_hlda() 
#define DEV_pic_iac()					BOCHS_GetIntVector()
#define DEV_pic_raise_irq(b)

// Used in memory/memory.cpp
#define DEV_adapter_mem_read(addr)		BOCHS_ReadAdapterByte(addr)
#define DEV_adapter_mem_write(addr,val)	BOCHS_WriteAdapterByte(addr,val)

// Usually defined in gui/siminterface.h
#define BX_RESET_HARDWARE				11

// Added to Bochs source code
Bit32u	BX_GETTICKS();
void	BX_INT1();

// Prototypes for #define's above
void	BOCHS_Tick( Bit32u nTicks );
Bit8u	BOCHS_GetIntVector();
Bit32u	BOCHS_ReadPort( Bit16u nPort, unsigned nLen );
void	BOCHS_WritePort( Bit16u nPort, Bit32u nValue, unsigned nLen );
Bit8u	BOCHS_ReadAdapterByte( Bit32u dwAddress );
void	BOCHS_WriteAdapterByte( Bit32u dwAddress, Bit8u nValue );

typedef struct
{
	// CPU interface
	tCPU86_Interface *pInterface;

	// FPU interface
	tFPU87_Interface *pFPUInterface;

	bool
		// Flag to indicate if CPU emulation is active
		bActive,

		// Flag to indicate if A20 address line is enabled
		bAddressMaskEnabled;

	// A20 address mask
	Bit32u dwAddressMask;

	// Refresh counters
	DWORD
		dwCurrentTicks,
		dwRefreshTicks,
		dwLastRefreshTicks;

	// Flag to indicate that system request is pending
	volatile bool bSysReqPending;
} tBOCHS_Interface;

extern tBOCHS_Interface theCPU;

#endif
