//  Copyright (C) 2004 PocketDOS
//
//    PocketDOS
//    http://www.pocketdos.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


#ifndef _DOSBOX_CPU_H
#define _DOSBOX_CPU_H

#include "stdafx.h"
#include <stdlib.h>
#include "dosbox.h"
#include "paging.h"
#include "CPU86_Interface.h"

typedef struct 
{
	// CPU interface
	tCPU86_Interface *pInterface;

	// CPU core level: 0 = Simple, 1 = Normal, 2 = Full
	int nCoreLevel;

	volatile bool
		// Flag to indicate if CPU emulation is active
		bActive,

		// Flag to indicate if asynchrounous event is pending
		bAsyncEvent,

		// Flag to indicate that system request is pending
		bSysReqPending,

		// Flag to indicate if A20 address line is enabled
		bAddressMaskEnabled;
} tDOSBOX_Interface;

extern tDOSBOX_Interface theCPU;

class AdapterMemHandler : public PageHandler
{
public:
	inline Bitu readb(PhysPt addr) 
	{
		return (*theCPU.pInterface->sMem.pfnReadByte)( addr );
	}

	inline Bitu readw(PhysPt addr)
	{
		return (*theCPU.pInterface->sMem.pfnReadWord)( addr );
	}

	inline Bitu readd(PhysPt addr)
	{
		return (*theCPU.pInterface->sMem.pfnReadDWord)( addr );
	}

	inline void writeb(PhysPt addr,Bitu val)
	{
		(*theCPU.pInterface->sMem.pfnWriteByte)( addr, val );
	}

	inline void writew(PhysPt addr,Bitu val)
	{
		(*theCPU.pInterface->sMem.pfnWriteWord)( addr, val );
	}

	inline void writed(PhysPt addr,Bitu val)
	{
		(*theCPU.pInterface->sMem.pfnWriteDWord)( addr, val );
	}

	inline HostPt GetHostPt(Bitu phys_page)
	{
		return (HostPt) &theCPU.pInterface->sReg.pMemory[phys_page << 12];
	}
};

#endif // _DOSBOX_CPU_H
