// Lemmings - Windows CE port by Jacco Bikker, a.k.a.
// "The Phantom"  -   Intended as a demonstration of
//   EasyCE - Visit http://www.cewarez.com/coding
// --------------------------------------------------
#include "easyce.h"
#include "lemmings.h"

#define FLAKES 400 // Number of snowflakes in level 1

// Statics (hey, who cares:)
unsigned short* LAnim::s_Frames = 0; // Ptr to anim image data
LAnim* walkleft, *walkright, *fallleft, *fallright, *stopper;
LAnim* bridgeleft, *bridgeright, *bomber, *digger, *axeman;
LAnim* floatleft, *floatright, *bashleft, *bashright;
LAnim* digleft, *digright, *climbleft, *climbright;
LAnim* edgeleft, *edgeright, *countdown, *dropdead;
LAnim* waitleft, *waitright, *goingin; // Available anims
unsigned short* p = 0; // Framebuffer pointer
unsigned short* f = 0; // Anim image data
unsigned short* t = 0; // Temporary image buffer
unsigned short* b1 = 0, *b2 = 0; // Button image data
int command = 0; // Selected command
int lactive = 0; // Number of lemmings active
int startx = 100, starty = 100; // Default spawn pos of lemmings
bool snow, paused = false, confirm = false, armageddon = false;
int rate, lmax, snupd, ex1, ey1, ex2, ey2;
int comcount[11] = { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20 };
int snx[FLAKES], sny[FLAKES];

Lemming::Lemming()
{
	m_Anim = 0;
	m_Frame = 0;
	m_Floater = m_Climber = m_Bomb = false;
}

Lemming::~Lemming()
{
}

int val( int n )
{
	int v1 = (n & (31 << 11)) >> 11;
	int v2 = (n & (63 << 5)) >> 6;
	int v3 = n & 31;
	return (v1 + v2 + v3) * 3;
}

void Lemming::update()
{
	if (!m_Anim) return;
	unsigned short* buff = p + m_X + 5 + m_Y * 240;
	unsigned short* wrt = t + m_X + 5 + m_Y * 240;
	if (m_Anim == walkleft)
	{
		m_X -= 1;
		buff -= 1;
		if (val(*(buff + 9 * 240)) > 40) 
		{
			m_Y--;
			if (val(*(buff + 8 * 240)) > 40) 
			{
				m_Y--;
				if (val(*(buff + 7 * 240)) > 40) 
				{
					m_Y--;
					if (val(*(buff + 6 * 240)) > 40) 
					{
						if (m_Climber)
						{
							m_Y += 3;
							m_X += 2;
							m_Anim = climbleft;
						}
						else
						{
							m_Anim = walkright;
							m_Y += 3;
						}
					}
				}
			}
		}
		else if (val(*(buff + 10 * 240)) < 40) 
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) 
				{
					m_Y++;
					if (val(*(buff + 12 * 240)) < 40) 
					{
						if (m_Floater) 
						{
							m_Y -= 6;
							m_Anim = floatleft; 
							m_Frame = 0;
						}
						else 
						{
							m_Anim = fallleft;
							m_Height = m_Y;
						}
					}
				}
			}
		}
	}
	else if (m_Anim == walkright)
	{
		m_X += 1;
		buff += 1;
		if (val(*(buff + 9 * 240)) > 40) 
		{
			m_Y--;
			if (val(*(buff + 8 * 240)) > 40) 
			{
				m_Y--;
				if (val(*(buff + 7 * 240)) > 40) 
				{
					m_Y--;
					if (val(*(buff + 6 * 240)) > 40) 
					{
						if (m_Climber)
						{
							m_Y += 3;
							m_X -= 2;
							m_Anim = climbright;
						}
						else
						{
							m_Anim = walkleft;
							m_Y += 3;
						}
					}
				}
			}
		}
		else if (val(*(buff + 10 * 240)) < 40) 
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40) 
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) 
				{
					m_Y++;
					if (val(*(buff + 13 * 240)) < 40)
					{ 
						if (m_Floater) 
						{
							m_Anim = floatright;
							m_Frame = 0;
							m_Y -= 6;
						}
						else 
						{
							m_Anim = fallright;
							m_Height = m_Y;
						}
					}
				}
			}
		}
	}
	else if (m_Anim == floatleft )
	{
		if (val(*(buff + 16 * 240)) < 40) m_Y++; else
		{
			m_Anim = walkleft;
			m_Y += 6;
		}
	}
	else if (m_Anim == fallleft )
	{
		bool hitground = false;
		if (m_Floater) m_Anim = floatleft;
		if (val(*(buff + 10 * 240)) < 40)
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 11 * 240)) < 40) m_Y++; else hitground = true;
			}
			else hitground = true;
		}
		else hitground = true;
		if (hitground)
		{
			if ((m_Y - m_Height) < 40) m_Anim = walkleft;
								  else m_Anim = dropdead;
		}
	}
	else if (m_Anim == floatright )
	{
		if (val(*(buff + 16 * 240)) < 40) m_Y++;	else
		{
			m_Anim = walkright;
			m_Y += 6;
		}
	}
	else if (m_Anim == fallright )
	{
		bool hitground = false;
		if (m_Floater) m_Anim = floatright;
		if (val(*(buff + 10 * 240)) < 40)
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 11 * 240)) < 40) m_Y++; else hitground = true;
			}
			else hitground = true;
		}
		else hitground = true;
		if (hitground)
		{
			if ((m_Y - m_Height) < 40) m_Anim = walkright;
								  else m_Anim = dropdead;
		}
	}
	else if (m_Anim == stopper)
	{
		// Do nothing special
	}
	else if (m_Anim == bridgeleft)
	{	
		if ((m_Frame == 9) && (m_Counter < 4))
			 play( L"\\Program Files\\EasyCE\\sounds\\ting.wav" );
		if (m_Frame == 15)
		{
			if (--m_Counter > 0)
			{
				*(wrt + 12 * 240 - 2) = 65535;
				*(wrt + 12 * 240 - 1) = 65535;
				*(wrt + 12 * 240) = 65535;
				m_X -= 2;
				m_Y -= 1;
				if (val(*(buff + 12 * 240 - 1)) > 40) 
				{
					m_Anim = walkright;
					m_Y += 3;
				}
			}
			else 
			{
				m_Anim = waitleft;
				m_Frame = 0;
			}
		}
	}
	else if (m_Anim == bridgeright)
	{
		if (m_Frame == 15)
		{
			if (--m_Counter > 0)
			{
				*(wrt + 12 * 240 + 2) = 65535;
				*(wrt + 12 * 240 + 3) = 65535;
				*(wrt + 12 * 240 + 4) = 65535;
				m_X += 2;
				m_Y -= 1;
				if (val(*(buff + 12 * 240 + 3)) > 40) 
				{
					m_Anim = walkleft;
					m_Y += 3;
				}
			}
			else 
			{
				m_Anim = waitright;
				m_Frame = 0;
			}
		}
	}
	else if (m_Anim == bomber)
	{
		if (m_Frame == 1) play( L"\\Program Files\\EasyCE\\sounds\\ohno.wav" );
		if (m_Frame == 15)
		{
			play( L"\\Program Files\\EasyCE\\sounds\\explode.wav" );
			for ( int sy = 0; sy < 23; sy++ )
			{
				unsigned short* src = f + 133 + ((1 + sy) << 8);
				for ( int sx = 0; sx < 17; sx++ )
					if (*(src + sx) != 0) *(wrt - 8 + sx + (sy - 4) * 240) = 0;
			}
		}
		if (m_Frame == 31) 
		{
			m_Anim = 0;
			lactive--;
		}
	}
	else if (m_Anim == digger)
	{
		if (m_Frame == 15)
		{
			for ( int i = 0; i < 9; i++ )
			{
				*(wrt + 12 * 240 - 4 + i) = 0;
				*(wrt + 12 * 240 + 236 + i) = 0;
			}
			for ( i = 0; i < 7; i++ ) *(wrt + 12 * 240 + 477 + i) = 0;
			m_Y += 2;
			if (val(*(buff + 14 * 240)) < 40) 
			{
				m_Anim = walkleft;
				m_Y -= 4;
			}
		}
	}
	else if (m_Anim == bashleft)
	{
		if ((m_Frame > 9) && (m_Frame < 14)) m_X--;
		if ((m_Frame > 25) && (m_Frame < 30)) m_X--;
		bool ready = true;
		for ( int sy = 0; sy < 10; sy++ )
		{
			if (*(buff - 4 + sy * 240) > 40)
			{
				ready = false;
				break;
			}
		}
		if (ready) m_Anim = walkleft;
		for ( sy = 0; sy < 10; sy++ )
		{
			unsigned short* src = f + 177 + (sy << 8);
			for ( int sx = 0; sx < 10; sx++ )
				if (*(src + sx) != 0) *(wrt - 4 + sx + sy * 240) = 0;
		}
	}
	else if (m_Anim == bashright)
	{
		if ((m_Frame > 9) && (m_Frame < 14)) m_X++;
		if ((m_Frame > 25) && (m_Frame < 30)) m_X++;
		bool ready = true;
		for ( int sy = 0; sy < 10; sy++ )
		{
			if (val(*(buff + 8 + sy * 240)) > 40)
			{
				ready = false;
				break;
			}
		}
		if (ready) m_Anim = walkright;
		for ( sy = 0; sy < 10; sy++ )
		{
			unsigned short* src = f + 163 + (sy << 8);
			for ( int sx = 0; sx < 10; sx++ )
				if (*(src + sx) != 0) *(wrt + 2 + sx + sy * 240) = 0;
		}
	}
	else if (m_Anim == digleft)
	{
		if (m_Frame == 16) 
		{
			m_Y++;
			m_X -= 2;
		}
	}
	else if (m_Anim == digright)
	{
		if (m_Frame == 16)
		{
			m_Y++;
			m_X += 2;
		}
	}
	else if (m_Anim == climbleft)
	{
		if (m_Frame > 4) m_Y--;
		if ((m_Frame < 5) && (val(*(buff + (4 - m_Frame) * 240 - 2)) < 40)) 
		{
			m_Anim = edgeleft;
			m_Y -= (m_Frame + 4);
			m_Frame = 0;
		}
		if (val(*(buff + 2 * 240 - 1)) > 40) m_Anim = fallright;
	}
	else if (m_Anim == climbright)
	{
		if (m_Frame > 4) m_Y--;
		if ((m_Frame < 5) && (val(*(buff + (4 - m_Frame) * 240 + 2)) < 40)) 
		{
			m_Anim = edgeright;
			m_Y -= (m_Frame + 4);
			m_Frame = 0;
		}
		if (val(*(buff + 2 * 240 + 1)) > 40) m_Anim = fallleft;
	}
	else if (m_Anim == edgeleft)
	{
		if (m_Frame == 7) 
		{
			m_Anim = walkleft;
			m_X -= 2;
		} 
	}
	else if (m_Anim == edgeright)
	{
		if (m_Frame == 7) 
		{
			m_Anim = walkright;
			m_X += 2;
		}
	}
	else if (m_Anim == dropdead)
	{
		if (m_Frame == 2) play( L"\\Program Files\\EasyCE\\sounds\\splat.wav" );
		if (m_Frame == 15)
		{
			m_Anim = 0;
			lactive--;
		}
	}
	else if (m_Anim == waitleft)
	{
		if (m_Frame == 11)
		{
			m_Anim = walkleft;
			m_Y += 3;
			m_Frame = 0;
		}
	}
	else if (m_Anim == waitright)
	{
		if (m_Frame == 11)
		{
			m_Anim = walkright;
			m_Y += 3;
			m_Frame = 0;
		}
	}
	else if (m_Anim == goingin)
	{
		if (m_Frame == 2) play( L"\\Program Files\\EasyCE\\sounds\\oing.wav" );
		if (m_Frame == 7)
		{
			m_Anim = 0;
			lactive--;
		}
	}
	if ((m_X >= ex1) && (m_X <= ex2) && (m_Y >= ey1) && (m_Y <= ey2))
	{
		m_Anim = goingin;
		m_Y -= 3;
		m_Frame = 0;
	}
}

void Lemming::draw( void )
{
	if (m_Anim) 
	{
		m_Frame++;
		if (m_Frame >= m_Anim->getframes()) 
		{
			if ((m_Anim == floatleft) || (m_Anim == floatright)) m_Frame = 4; else m_Frame = 0;
		}
		m_Anim->update( m_X, m_Y, m_Frame );
	}
	if (m_Bomb)
	{
		int bc = --m_BCount / 8;
		if (bc == 0)
		{
			m_Anim = bomber;
			m_Bomb = false;
			m_Frame = 0;
		}
		else
		{
			countdown->update( m_X + 3, m_Y - 6, bc - 1 );
		}
	}
}

LAnim::LAnim()
{
	m_Frames = 0;
}

LAnim::~LAnim()
{
}

void LAnim::update( int x, int y, int frame )
{
	unsigned short* src = s_Frames + m_Fx[frame] + (m_Fy[frame] << 8);
	unsigned short* dst = p + x + y * 240;
	for ( int v = 0; v < m_Fszy; v++ )
	{
		for ( int h = 0; h < m_Fszx; h++ )
		{
			unsigned short pixel = *(src + h);
			if (pixel > 0) *(dst + h) = pixel;
		}
		src += 256;
		dst += 240;
	}
}

void initanims()
{
	LAnim::s_Frames = f;
	walkright = new LAnim();
	walkright->setframes( 8 );
	walkright->setsize( 10, 10 );
	for ( int i = 0; i < 8; i++ ) walkright->setfpos( i, i * 16, 0 );
	walkleft = new LAnim();
	walkleft->setframes( 8 );
	walkleft->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) walkleft->setfpos( i, (7 - i) * 16, 10 );
	fallright = new LAnim();
	fallright->setframes( 4 );
	fallright->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) fallright->setfpos( i, i * 16, 10 );
	fallleft = new LAnim();
	fallleft->setframes( 4 );
	fallleft->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) fallleft->setfpos( i, i * 16, 10 );
	stopper = new LAnim();
	stopper->setframes( 16 );
	stopper->setsize( 12, 10 );
	for ( i = 0; i < 16; i++ ) stopper->setfpos( i, i * 16, 148 );
	bridgeleft = new LAnim();
	bridgeleft->setframes( 16 );
	bridgeleft->setsize( 16, 13 );
	for ( i = 0; i < 16; i++ ) bridgeleft->setfpos( i, i * 16, 208 );
	bridgeright = new LAnim();
	bridgeright->setframes( 16 );
	bridgeright->setsize( 16, 13 );
	for ( i = 0; i < 16; i++ ) bridgeright->setfpos( i, i * 16, 195 );
	bomber = new LAnim();
	bomber->setframes( 32 );
	bomber->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bomber->setfpos( i, i * 16, 128 );
	for ( i = 0; i < 16; i++ ) bomber->setfpos( i + 16, i * 16, 138 );
	floatleft = new LAnim();
	floatleft->setframes( 12 );
	floatleft->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) floatleft->setfpos( i, i * 16, 112 );
	for ( i = 0; i < 4; i++ ) floatleft->setfpos( i + 8, (7 - i) * 16, 112 );
	floatright = new LAnim();
	floatright->setframes( 12 );
	floatright->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) floatright->setfpos( i, i * 16, 96 );
	for ( i = 0; i < 4; i++ ) floatright->setfpos( i + 8, (7 - i) * 16, 96 );
	digger = new LAnim();
	digger->setframes( 16 );
	digger->setsize( 16, 14 );
	for ( i = 0; i < 16; i++ ) digger->setfpos( i, i * 16, 247 );
	bashleft = new LAnim();
	bashleft->setframes( 32 );
	bashleft->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bashleft->setfpos( i, i * 16, 281 );
	for ( i = 0; i < 16; i++ ) bashleft->setfpos( i + 16, i * 16, 291 );
	bashright = new LAnim();
	bashright->setframes( 32 );
	bashright->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bashright->setfpos( i, i * 16, 261 );
	for ( i = 0; i < 16; i++ ) bashright->setfpos( i + 16, i * 16, 271 );
	digleft = new LAnim();
	digleft->setframes( 24 );
	digleft->setsize( 16, 13 );
	for ( i = 0; i < 12; i++ ) digleft->setfpos( i, i * 16, 327 );
	for ( i = 0; i < 12; i++ ) digleft->setfpos( i + 12, i * 16, 340 );
	digright = new LAnim();
	digright->setframes( 24 );
	digright->setsize( 16, 13 );
	for ( i = 0; i < 12; i++ ) digright->setfpos( i, i * 16, 301 );
	for ( i = 0; i < 12; i++ ) digright->setfpos( i + 12, i * 16, 314 );
	climbleft = new LAnim();
	climbleft->setframes( 8 );
	climbleft->setsize( 16, 11 );
	for ( i = 0; i < 8; i++ ) climbleft->setfpos( i, i * 16, 53 );
	climbright = new LAnim();
	climbright->setframes( 8 );
	climbright->setsize( 16, 11 );
	for ( i = 0; i < 8; i++ ) climbright->setfpos( i, i * 16, 41 );
	edgeleft = new LAnim();
	edgeleft->setframes( 8 );
	edgeleft->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) edgeleft->setfpos( i, i * 16, 80 );
	edgeright = new LAnim();
	edgeright->setframes( 8 );
	edgeright->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) edgeright->setfpos( i, i * 16, 64 );
	countdown = new LAnim();
	countdown->setframes( 5 );
	countdown->setsize( 5, 5 );
	for ( i = 0; i < 5; i++ ) countdown->setfpos( i, i * 16 + 135, 116 );
	dropdead = new LAnim();
	dropdead->setframes( 16 );
	dropdead->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) dropdead->setfpos( i, i * 16, 138 );
	waitleft = new LAnim();
	waitleft->setframes( 12 );
	waitleft->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) waitleft->setfpos( i, i * 16, 234 );
	for ( i = 8; i < 12; i++ ) waitleft->setfpos( i, 7 * 16, 234 );
	waitright = new LAnim();
	waitright->setframes( 12 );
	waitright->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) waitright->setfpos( i, i * 16, 221 );
	for ( i = 8; i < 12; i++ ) waitright->setfpos( i, 7 * 16, 221 );
	goingin = new LAnim();
	goingin->setframes( 8 );
	goingin->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) goingin->setfpos( i, i * 16, 182 );
}

bool title()
{
	loadtga( L"Program Files\\EasyCE\\title_pal.tga", 240, 320, p, true );
	while (1)
	{
		if (clicked())
		{
			int x = clickxpos();
			int y = clickypos();
			// if ((x > 160) && (y < 20) && (x < 215)) options();
			if ((x > 180) && (y > 270)) return false;
			if ((x < 20) && (y > 293)) snapshot();
			if ((x > 97) && (x < 216))
			{
				if ((y > 35) && (y < 62))
				{
					loadtga( L"Program Files\\EasyCE\\level4.tga", 240, 240, p, true );
					ex1 = 77; ey1 = 202;
					ex2 = 81; ey2 = 236;
					startx = 188; starty = 17;
					snow = true;
					rate = 32;
					lmax = 40;
					// comcount = { 0, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20 };
					return true;
				}
				else if ((y > 71) && (y < 98))
				{
					loadtga( L"Program Files\\EasyCE\\level1b.tga", 240, 240, p, true );
					ex1 = 190; ey1 = 74;
					ex2 = 198; ey2 = 90;
					startx = 69; starty = 57;
					rate = 32;
					lmax = 40;
					return true;
				}
				else if ((y > 106) && (y < 132))
				{
					loadtga( L"Program Files\\EasyCE\\level5.tga", 240, 240, p, true );
					ex1 = 31; ey1 = 212;
					ex2 = 33; ey2 = 234;
					startx = 124; starty = 23;
					rate = 64;
					lmax = 40;
					return true;
				}
				else if ((y > 141) && (y < 168))
				{
					loadtga( L"Program Files\\EasyCE\\level3.tga", 240, 240, p, true );
					ex1 = 193; ey1 = 200;
					ex2 = 197; ey2 = 226;
					startx = 34; starty = 23;
					rate = 22;
					lmax = 80;
					return true;
				}
			}
		}
		update();
	}
}

void printcount( int n, int x1, int y1 )
{
	bar( x1, y1, x1 + 14, y1 + 7, 0 );
	char* tmp = new char[4];
	tmp[2] = 0;
	int d1 = n % 10;
	int d2 = n / 10;
	tmp[0] = d2 + '0';
	tmp[1] = d1 + '0';
	print( tmp, x1, y1, 65535 );
}

void updatecounts()
{
	printcount( comcount[1], 15, 245 );
	printcount( comcount[2], 49, 245 );
	printcount( comcount[3], 84, 245 );
	printcount( comcount[4], 119, 245 );
	printcount( comcount[5], 153, 245 );
	printcount( comcount[6], 185, 245 );
	printcount( comcount[7], 219, 245 );
	printcount( comcount[10], 219, 285 );
}

void updatesnow()
{
	if (snupd == 1) snupd = 0; else snupd = 1;
	for ( int i = 0; i < FLAKES; i++ )
	{
		if ((i & 1) == snupd)
		{
			int dir = rand() & 3;
			if (dir == 0) 
			{
				snx[i]++; 
				if (snx[i] > 239) snx[i] = 0;
			}
			else if (dir == 1)
			{	
				snx[i]--;
				if (snx[i] < 1) snx[i] = 239;
			}
			sny[i] += (i & 3) + 1;
			if (sny[i] > 239) sny[i] = 0;
		}
		*(p + snx[i] + sny[i] * 240) = 65535;
	}
}

void main()
{
	t = new unsigned short[240 * 240];
	p = (unsigned short*)getbuffer();
	f = new unsigned short[256 * 354];
	b1 = new unsigned short[240 * 80];
	b2 = new unsigned short[240 * 80];
	loadtga( L"Program Files\\EasyCE\\lemanim.tga", 256, 354, f, true );
	loadtga( L"Program Files\\EasyCE\\buttons.tga", 240, 80, b1, true );
	loadtga( L"Program Files\\EasyCE\\bbuttons.tga", 240, 80, b2, true );
	initanims();
	for ( int i = 0; i < FLAKES; i++ )
	{
		snx[i] = (rand() * 240) / RAND_MAX;
		sny[i] = i % 240;
	}
	while (1)
	{
		command = 0;
		lactive = 0;
		snow = false;
		paused = confirm = armageddon = false;
		if (!title()) break;
		resettimer();
		play( L"\\Program Files\\EasyCE\\sounds\\door.wav" );
		while (msecs() < 500) {};
		play( L"\\Program Files\\EasyCE\\sounds\\letsgo.wav" );
		memcpy( t, p, 240 * 240 * 2);
		memcpy( p + 240 * 240, b1, 240 * 160 );
		updatecounts();
		Lemming* lemm[80];
		for ( int i = 0; i < 80; i++ ) lemm[i] = 0;
		int delay = 1;
		int lemmings = 0;
		int lcount = rate;
		int lout = 0;
		for ( i = 0; i < 11; i++ ) comcount[i] = 20;
		while (1)
		{
			if (!paused)
			{
				if (msecs() > 80)
				{
					resettimer();
					memcpy( p, t, 240 * 480 );
					for ( int i = 0; i < lemmings; i++ ) lemm[i]->update();
					for ( i = 0; i < lemmings; i++ ) lemm[i]->draw();
					if (snow) updatesnow();
					update();
					if ((lemmings < lmax) && (!armageddon))
					{
						if (--lcount == 0)
						{
							lemm[lemmings] = new Lemming();
							lemm[lemmings]->setpos( startx, starty );
							lemm[lemmings++]->setanim( walkleft );
							lcount = rate;
							lactive++;
							lout++;
						}
					}
				}
			}
			if (armageddon && (!lactive)) break;
			if ((lout == 40) && (lactive == 0)) break;
			if (clicked()) 
			{
				int x = clickxpos();
				int y = clickypos();
				if ((x < 20) && (y < 20)) snapshot();
				if ((y > 240) && (y < 281))
				{
					confirm = false;
					memcpy( p + 240 * 240, b1, 480 * 80 );
					if (x < 34)
					{
						if (comcount[1] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h) = *(b2 + h + v * 240);
							command = 1;
						}
					}
					else if (x < 69)
					{
						if (comcount[2] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 34) = *(b2 + h + v * 240 + 34);
							command = 2;
						}
					}
					else if (x < 103)
					{
						if (comcount[3] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 69) = *(b2 + h + v * 240 + 69);
							command = 3;
						}
					}
					else if (x < 137)
					{
						if (comcount[4] > 0) 
						{
							command = 4;
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 103) = *(b2 + h + v * 240 + 103);
						}
					}
					else if (x < 171)
					{
						if (comcount[5] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 137) = *(b2 + h + v * 240 + 137);
							command = 5;
						}
					}
					else if (x < 206)
					{
						if (comcount[6] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 171) = *(b2 + h + v * 240 + 171);
							command = 6;
						}
					}
					else
					{
						if (comcount[7] > 0) 
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 206) = *(b2 + h + v * 240 + 206);
							command = 7;
						}
					}
					play( L"\\Program Files\\EasyCE\\sounds\\changeop.wav" );
					updatecounts();
				}
				else if ((y > 280) && (y < 320))
				{
					memcpy( p + 240 * 240, b1, 480 * 80 );
					if (x < 34)
					{
						for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
							*(p + (v + 280) * 240 + h) = *(b2 + h + (v + 40) * 240);
						command = 8;
						paused = !paused;
						confirm = false;
					}
					else if (x < 69)
					{
						if (!armageddon)
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 280) * 240 + h + 34) = *(b2 + h + (v + 40) * 240 + 34);
							if (confirm)
							{
								for ( int i = 0; i < lemmings; i++ ) if (lemm[i]->getanim()) lemm[i]->isbomb();
								armageddon = true;
							}
							else confirm = true;
						}
					}
					else if (x > 206)
					{
						if (comcount[10] > 0)
						{
							for ( int v = 0; v < 40; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 280) * 240 + h + 206) = *(b2 + h + (v + 40) * 240 + 206);
							command = 10;
						}
						confirm = false;
					}
					play( L"\\Program Files\\EasyCE\\sounds\\changeop.wav" );
					updatecounts();
				}
				else 
				{
					confirm = false;
					if (command > 0)
					{
						for ( int i = 0; i < lemmings; i++ )
						{
							int lx = lemm[i]->getxpos() - 5;
							int ly = lemm[i]->getypos() - 5;
							if ((x > lx) && (x < (lx + 20)) && (y > ly) && (y < (ly + 20)))
							{
								if (command == 4)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == walkright))
									{
										comcount[4]--;
										lemm[i]->setanim( stopper );
										unsigned short* b = t + 11 + lx + (9 + ly) * 240;
										for ( int i = 0; i < 8; i++ )
										{
											if (val(*(b + i * 240)) < 40) *(b + i * 240) = 41 + (41 << 5) + (41 << 11);
											if (val(*(b + 1 + i * 240)) < 40) *(b + 1 + i * 240) = 41 + (41 << 5) + (41 << 11);
										}
									}
									break;
								}
								else if (command == 5)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == waitleft))
									{
										comcount[5]--;
										if (lemm[i]->getanim() == walkleft) lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										                               else lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos());
										lemm[i]->setanim( bridgeleft );
										lemm[i]->setframe( 0 );
										lemm[i]->setcounter( 10 );
									}
									else if ((lemm[i]->getanim() == walkright) ||
									         (lemm[i]->getanim() == waitright))
									{
										comcount[5]--;
										if (lemm[i]->getanim() == walkright) lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										                                else lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos());
										lemm[i]->setanim( bridgeright );
										lemm[i]->setframe( 0 );
										lemm[i]->setcounter( 10 );
									}
									break;
								}
								else if (command == 3)
								{
									if (!lemm[i]->getbomb())
									{
										comcount[3]--;
										lemm[i]->isbomb();
									}
									break;
								}
								else if (command == 2)
								{
									if (!lemm[i]->getfloat())
									{
										comcount[2]--;
										lemm[i]->isfloater();
									}
									break;
								}
								else if (command == 10)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == walkright))
									{	comcount[10]--;
										lemm[i]->setanim( digger );
										lemm[i]->setframe( 0 );
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 2);
									}
									break;
								}
								else if (command == 6)
								{
									if (lemm[i]->getanim() == walkleft)
									{
										comcount[6]--;
										lemm[i]->setanim( bashleft );
										lemm[i]->setframe( 0 );
									}					
									else if (lemm[i]->getanim() == walkright)
									{
										comcount[6]--;
										lemm[i]->setanim( bashright );
										lemm[i]->setframe( 0 );
									}
									break;
								}
								else if (command == 7)
								{
									if (lemm[i]->getanim() == walkleft)
									{
										comcount[7]--;
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										lemm[i]->setanim( digleft );
										lemm[i]->setframe( 0 );
									}					
									else if (lemm[i]->getanim() == walkright)
									{
										comcount[7]--;
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										lemm[i]->setanim( digright );
										lemm[i]->setframe( 0 );
									}
									break;
								}
								else if (command == 1)
								{
									comcount[1]--;
									lemm[i]->isclimber();
									break;
								}
							}
						}
						updatecounts();
					}
				}
			}
		}
		for ( i = 0; i < lemmings; i++ ) delete lemm[i];
	}
	delete t;
	delete f;
	delete walkright;
	delete walkleft;
	delete fallleft;
	delete fallright;
	delete bridgeleft;
	delete bridgeright;
	delete bomber;
	delete stopper;
	delete floatleft;
	delete floatright;
	delete digger;
	delete bashleft;
	delete bashright;
	delete digleft;
	delete digright;
	delete climbleft;
	delete climbright;
	delete edgeleft;
	delete edgeright;
	delete countdown;
	delete dropdead;
	delete waitleft;
	delete waitright;
	delete goingin;
}

// --------------------------------------------------
// EOF