/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.lcdui;

import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.IGolfHole;
import com.ibm.weme.examples.golftracker.lcdui.IView;
import com.ibm.weme.examples.golftracker.lcdui.IViewManager;
import com.ibm.weme.examples.golftracker.model.IGolfScoreTrackerConstants;
import com.ibm.weme.examples.golftracker.resources.GolfTrackerImages;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;

public final class MapView
implements IView,
CommandListener {
    private ImageItem map;
    private IGolfHole hole;
    private IGolfGame game;
    private Form form;
    private IViewManager viewManager;
    private Command score;
    private Command previous;
    private Command next;
    private Command newGame;
    private Command exit;

    public MapView(IViewManager viewManager) {
        this.viewManager = viewManager;
        this.buildForm();
    }

    public final Form getForm() {
        this.game = this.viewManager.getGame();
        this.hole = this.game.getCurrentHole();
        StringBuffer buf = new StringBuffer(32);
        buf.append(IGolfScoreTrackerConstants.HOLE_LABEL);
        buf.append(' ');
        buf.append(this.hole.getNumber());
        this.form.setTitle(buf.toString());
        buf = new StringBuffer(16);
        buf.append(this.hole.getYardage());
        buf.append(' ');
        buf.append(IGolfScoreTrackerConstants.YARDS_STRING);
        buf.append(',');
        buf.append(' ');
        buf.append(IGolfScoreTrackerConstants.PAR_STRING);
        buf.append(' ');
        buf.append(this.hole.getPar());
        this.map.setLabel(buf.toString());
        Image image = null;
        try {
            String mapFileName = this.hole.getMapFileName();
            if (mapFileName != null) {
                InputStream is = new GolfTrackerImages().getClass().getResourceAsStream(mapFileName);
                image = Image.createImage((InputStream)is);
                is.close();
            }
        }
        catch (IOException iOException) {
            IOException e = iOException;
            iOException.printStackTrace();
            image = null;
        }
        this.map.setImage(image);
        this.map.setAltText(IGolfScoreTrackerConstants.NO_MAP_AVAILABLE);
        return this.form;
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == this.previous) {
            this.previous();
        } else if (command == this.score) {
            this.score();
        } else if (command == this.next) {
            this.next();
        } else if (command == this.newGame) {
            this.newGame();
        } else if (command == this.exit) {
            this.exit();
        }
    }

    public final void cleanup() {
        this.map = null;
        this.hole = null;
        this.game = null;
        this.form = null;
        this.viewManager = null;
        this.score = null;
        this.previous = null;
        this.next = null;
        this.newGame = null;
    }

    private final void buildForm() {
        this.form = new Form(IGolfScoreTrackerConstants.MAP_LABEL);
        this.map = new ImageItem(null, null, 259, IGolfScoreTrackerConstants.NO_MAP_AVAILABLE);
        this.form.append((Item)this.map);
        this.previous = new Command(IGolfScoreTrackerConstants.PREVIOUS_COMMAND, 1, 1);
        this.form.addCommand(this.previous);
        this.score = new Command(IGolfScoreTrackerConstants.SCORE_COMMAND, 1, 1);
        this.form.addCommand(this.score);
        this.next = new Command(IGolfScoreTrackerConstants.NEXT_COMMAND, 1, 1);
        this.form.addCommand(this.next);
        this.newGame = new Command(IGolfScoreTrackerConstants.NEW_GAME_COMMAND, 8, 2);
        this.form.addCommand(this.newGame);
        this.exit = new Command(IGolfScoreTrackerConstants.EXIT_LABEL, 7, 3);
        this.form.addCommand(this.exit);
        this.form.setCommandListener((CommandListener)this);
    }

    private final void score() {
        this.viewManager.showView(1);
    }

    private final void previous() {
        this.game.previousHole();
        this.viewManager.showView(2);
    }

    private final void next() {
        this.game.nextHole();
        this.viewManager.showView(2);
    }

    private final void newGame() {
        this.viewManager.showView(0);
    }

    private final void exit() {
        this.viewManager.exitGame();
    }
}

