/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class GolfTrackerMessages {
    private static Hashtable messages = null;

    static {
        try {
            messages = GolfTrackerMessages.loadMessages("GolfTrackerMessages");
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
        }
    }

    public static String getString(String msg) {
        if (messages == null) {
            return msg;
        }
        String resource = (String)messages.get(msg);
        if (resource == null) {
            return msg;
        }
        return resource;
    }

    public static String getString(String msg, Object arg) {
        return GolfTrackerMessages.getString(msg, new Object[]{arg});
    }

    public static String getString(String msg, int arg) {
        return GolfTrackerMessages.getString(msg, new Object[]{Integer.toString(arg)});
    }

    public static String getString(String msg, char arg) {
        return GolfTrackerMessages.getString(msg, new Object[]{String.valueOf(arg)});
    }

    public static String getString(String msg, Object arg1, Object arg2) {
        return GolfTrackerMessages.getString(msg, new Object[]{arg1, arg2});
    }

    public static String getString(String msg, Object[] args) {
        String format = msg;
        if (messages != null && (format = (String)messages.get(msg)) == null) {
            format = msg;
        }
        return GolfTrackerMessages.format(format, args);
    }

    public static String getIndirectString(String msg, Object[] args) {
        if (messages == null) {
            return msg;
        }
        String key = (String)messages.get(msg);
        if (key == null) {
            return msg;
        }
        return GolfTrackerMessages.getString(key, args);
    }

    private static String format(String format, Object[] args) {
        StringBuffer answer = new StringBuffer();
        String[] argStrings = new String[args.length];
        int i = 0;
        while (i < args.length) {
            argStrings[i] = args[i] == null ? "<null>" : args[i].toString();
            ++i;
        }
        int lastI = 0;
        int i2 = format.indexOf(123, 0);
        while (i2 >= 0) {
            if (i2 != 0 && format.charAt(i2 - 1) == '\\') {
                if (i2 != 1) {
                    answer.append(format.substring(lastI, i2 - 1));
                }
                answer.append('{');
                lastI = i2 + 1;
            } else if (i2 > format.length() - 3) {
                answer.append(format.substring(lastI, format.length()));
                lastI = format.length();
            } else {
                byte argnum = (byte)Character.digit(format.charAt(i2 + 1), 10);
                if (argnum < 0 || format.charAt(i2 + 2) != '}') {
                    answer.append(format.substring(lastI, i2 + 1));
                    lastI = i2 + 1;
                } else {
                    answer.append(format.substring(lastI, i2));
                    if (argnum >= argStrings.length) {
                        answer.append("<missing argument>");
                    } else {
                        answer.append(argStrings[argnum]);
                    }
                    lastI = i2 + 3;
                }
            }
            i2 = format.indexOf(123, lastI);
        }
        if (lastI < format.length()) {
            answer.append(format.substring(lastI, format.length()));
        }
        return answer.toString();
    }

    private static Hashtable loadMessages(String resourceName) throws Exception {
        InputStream resourceStream;
        String resName;
        String variant;
        String region;
        GolfTrackerMessages msgs = new GolfTrackerMessages();
        String language = System.getProperty("user.language");
        if (language == null) {
            language = "en";
        }
        if ((region = System.getProperty("user.region")) == null) {
            region = "US";
        }
        if ((variant = System.getProperty("user.variant")) != null) {
            resName = String.valueOf(resourceName) + "_" + language + "_" + region + "_" + variant + ".properties";
            resourceStream = msgs.getClass().getResourceAsStream(resName);
            if (resourceStream != null) {
                return GolfTrackerMessages.load(resourceStream);
            }
        }
        resName = String.valueOf(resourceName) + "_" + language + "_" + region + ".properties";
        resourceStream = msgs.getClass().getResourceAsStream(resName);
        if (resourceStream != null) {
            return GolfTrackerMessages.load(resourceStream);
        }
        resName = String.valueOf(resourceName) + "_" + language + ".properties";
        resourceStream = msgs.getClass().getResourceAsStream(resName);
        if (resourceStream != null) {
            return GolfTrackerMessages.load(resourceStream);
        }
        return GolfTrackerMessages.load(msgs.getClass().getResourceAsStream(String.valueOf(resourceName) + ".properties"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Hashtable load(InputStream resourceStream) throws IOException {
        int nextChar;
        boolean NONE = false;
        boolean SLASH = true;
        int UNICODE = 2;
        int CONTINUE = 3;
        int DONE = 4;
        int IGNORE = 5;
        Hashtable<String, String> messages = new Hashtable<String, String>();
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        block17: while ((nextChar = resourceStream.read()) != -1) {
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length << 1];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) continue;
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10) continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case 13: {
                        mode = 3;
                        continue block17;
                    }
                    case 10: {
                        mode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((nextChar = resourceStream.read()) != -1 && nextChar != 13 && nextChar != 10) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        mode = 0;
                        firstChar = true;
                        if (keyLength >= 0) {
                            String temp = new String(buf, 0, offset);
                            messages.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        mode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (GolfTrackerMessages.isWhitespace((char)nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = (char)nextChar;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            messages.put(temp.substring(0, keyLength), temp.substring(keyLength));
        }
        resourceStream.close();
        return messages;
    }

    public static boolean isWhitespace(char c) {
        if (c >= '\u001c' && c <= ' ' || c >= '\t' && c <= '\r') {
            return true;
        }
        if (c < '\u2000') {
            return false;
        }
        return c <= '\u200b' || c == '\u2028' || c == '\u2029' || c == '\u3000';
    }
}

