package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

public class Event {

	/*
	 * Using negative values so that these events do not conflict
	 * with OS event types.
	 */
	public final static int KEY_PRESSED = -1;
	public final static int KEY_RELEASED = -2;
	public final static int KEY_REPEATED = -3;

	public final static int POINTER_PRESSED = -4;
	public final static int POINTER_RELEASED = -5;
	public final static int POINTER_DRAGGED = -6;
	public final static int POINTER_MOVED = -7;

	public final static int MENU_OPENING = -8;
	public final static int MENU_CLOSING = -9;
	public final static int MENU_SELECTED = -10;

	public final static int WINDOW_ACTIVATE = -11;
	public final static int WINDOW_DEACTIVATE = -12;
	public final static int WINDOW_OBSCURED = -13;
	public final static int WINDOW_RESIZE = -14;
    public final static int WINDOW_CLOSED = -15;
	public final static int WINDOW_PAINT = -16;

	public final static int VERTICAL_SCROLL = -17;

	public final static int CHARACTER = -18;
	public final static int COMMAND = -19;
	public final static int BACK = -20;

	public final static int WINDOW_FOCUSIN = -21;
	public final static int WINDOW_FOCUSOUT = -22;

	//DTN_CLOSEUP in Win32
	public final static int DATE_CALENDAR_CLOSE = -23;

	/*
	 * Added to process cut, paste, clear and undo operations
	 * on a password field
	 */
	public final static int TEXTFIELD_PASTE = -24;
	public final static int TEXTFIELD_CUT = -25;
	public final static int TEXTFIELD_CLEAR = -26;
	public final static int TEXTFIELD_UNDO = -27;

	/* The following are events we will post to a target operating system to wake up the UI thread. */
	private static final int USER_EVENT = 0x400; // Valid for win32 and qt, other platforms may need to adjust this value.
	public static final int EVENT_UI_RUNNABLE = USER_EVENT + 1;
	public static final int EVENT_DISPLAYABLE_UPDATE_RUNNABLE = USER_EVENT + 2;
	public static final int EVENT_STOP = USER_EVENT + 4;

	public int fType;
	public int fX, fY;
	public int fKeyCode;
	public int fScrollOrSelectionIndex;
	public int fHandle;
	public int fArg1, fArg2;

	public Event() {
	}

	public Event(int type) {
		fType = type;
	}

	public Event(int handle, int type, int arg1, int arg2) {
		fHandle = handle;
		fType = type;
		fX = fArg1 = fScrollOrSelectionIndex = fKeyCode = arg1;
		fY = fArg2 = arg2;
	}

	public Event(int type, int x, int y) {
		fType = type;
		fX = x;
		fY = y;
	}

	public Event(int type, int keyCode) {
		fType = type;
		fKeyCode = keyCode;
	}

	public Event clone() {
		Event e = new Event(fType);
		e.fX = this.fX;
		e.fY = this.fY;
		e.fKeyCode = this.fKeyCode;
		e.fScrollOrSelectionIndex = this.fScrollOrSelectionIndex;
		e.fHandle = this.fHandle;
		e.fArg1 = this.fArg1;
		e.fArg2 = this.fArg2;
		return e;
	}
}
