package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

public interface IEventListener {

	/**
	 * Any event other than pointer events.
	 * Some implementations will pass events to the OS if they are not
	 * handled in the midp implementation.
	 * @return true if the event is handled by the midp implementation.
	 * @return false if the event is not handled by the midp implementation
	 * and should be passed to the OS event handlers.
	 * @param e the event
	 */
	public boolean dispatchEvent(Event e);

	/**
	 * Pointer events
	 * Some implementations will pass events to the OS if they are not
	 * handled in the midp implementation.
	 * @return true if the event is handled by the midp implementation.
	 * @return false if the event is not handled by the midp implementation
	 * and should be passed to the OS event handlers.
	 * @param e the pointer event
	 */
	public boolean dispatchPointerEvent(Event e);

	public boolean getAllowMenuEvents();
}
