package com.ibm.ive.midp;

import com.ibm.oti.security.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */
public interface IMIDletPermissions {

	// The MIDlet metadata class for storing information.
	// For more information on MIDlet metadata, see
	//com.ibm.oti.midlet.help.MidletLoader#getMetadataEntry(String, String, String, String).
	public static final String METADATA_CLASSNAME = "com.ibm.ive.midp.IMIDletPermissions"; //$NON-NLS-1$

	public static final String INVALID_GROUP = "permission.grouping.error"; //$NON-NLS-1$
	public static final String INVALID_QUESTION = "permission.interaction.error.txt"; //$NON-NLS-1$
	public static final String NO_INTERACTION_REQUIRED = "permission.interaction.empty"; //$NON-NLS-1$

	// keys for accessing messages on PermissionsPage for setting a user permission
	// interaction mode
	public static final String INTERACTION_MSG = "pref_"; //$NON-NLS-1$
	public static final String INTERACTION_DENY_MSG = "interaction_deny"; //$NON-NLS-1$
	public static final String INTERACTION_ONESHOT_MSG = "interaction_oneshot"; //$NON-NLS-1$
	public static final String INTERACTION_SESSION_MSG = "interaction_session"; //$NON-NLS-1$
	public static final String INTERACTION_BLANKET_MSG = "interaction_blanket"; //$NON-NLS-1$

	// keys for accessing messages on the UserPermission dialog
	public static final String USER_PERMISSION_INTERACTION = "query_allow_interaction_mode"; //$NON-NLS-1$
	public static final String USER_PERMISSION_MSG = "query_"; //$NON-NLS-1$
	public static final String USER_ONESHOT_MSG = "query_oneshot_"; //$NON-NLS-1$
	public static final String USER_SESSION_MSG = "query_session_"; //$NON-NLS-1$
	public static final String USER_DENY_MSG = "user_deny"; //$NON-NLS-1$
	public static final String USER_DENY_ONCE_MSG = "user_deny_once"; //$NON-NLS-1$
	public static final String USER_GRANT_ONCE_MSG= "user_grant_once"; //$NON-NLS-1$
	public static final String USER_GRANT_SESSION_MSG = "user_grant_session"; //$NON-NLS-1$
	public static final String USER_DENY_SESSION_MSG = "user_deny_session"; //$NON-NLS-1$
	public static final String USER_BLANKET_MSG = "user_blanket"; //$NON-NLS-1$
	public static final String USER_YES_MSG = "yes"; //$NON-NLS-1$
	public static final String USER_NO_MSG = "no"; //$NON-NLS-1$

	// user's response when prompted for a permission
	public static final int USER_DENY_ALWAYS = UserPermissionAgent.MODE_DENY_ALWAYS;
	public static final int USER_DENY_ONCE = UserPermissionAgent.MODE_DENY_ONCE;
	public static final int USER_GRANT_ONCE = UserPermissionAgent.MODE_GRANT_ONCE;
	public static final int USER_DENY_SESSION = UserPermissionAgent.MODE_DENY_SESSION;
	public static final int USER_GRANT_SESSION = UserPermissionAgent.MODE_GRANT_SESSION;
	public static final int USER_GRANT_ALWAYS = UserPermissionAgent.MODE_GRANT_ALWAYS;

	// number of response choices that the user should see for an interaction mode
	public final int ONESHOT_RESPONSES = 2;
	public final int SESSION_RESPONSES = 3;
	public final int BLANKET_RESPONSES = 4;

	// user's interaction mode for a permission and
	// the order the response choices appear to the user
	public static final int DENY = 0;
	public static final int ONESHOT = 1;
	public static final int SESSION = 2;
	public static final int BLANKET = 3;
	public static final int ALLOWED = 4;
}
