package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

public class MediaAccessManager {

	private static FastVector gAccessors;

	public static void addAccessor(Object obj, IMediaAccessor accessor) {
		if (gAccessors == null) gAccessors = new FastVector(10);
		AccessorReference ref = new AccessorReference(obj, accessor);
		gAccessors.addElement(ref);
	}

	public static IMediaAccessor getAccessor(Object obj) {
		if (gAccessors == null) return null;

		int size = gAccessors.size();
		for (int i = 0; i < size; i++) {
			AccessorReference next = (AccessorReference) gAccessors.elementAt(i);
			if (next.fObject.get() == obj) {
				return (IMediaAccessor) next.fAccessor.get();
			}
		}
		return null;
	}

}
