
package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

public class OS {

//TODO: Can these be made final?
	public static boolean IsWinCE;
	public static boolean IsSP;
	public static boolean IsPPCWM2003;
	public static boolean IsPPCWM5;
	public static boolean usesSoftKeys;

	static {
		int type = getOsType();
		IsWinCE = type > 0;
		IsSP = type == 1;
		IsPPCWM2003 = type == 2;
		IsPPCWM5 = type == 3;
		usesSoftKeys = IsSP || IsPPCWM5;
	}

	public static final boolean IsUnicode = true;

	public static final native int createMenuBar(int handle, int id);

	public static final native int getOsType();
	public static final native int CreateWindow(String className, int x, int y, int width, int height);
	//public static final native void init();
	public static final native void SetWindowPos(int handle, int insertAfter, int x, int y, int width, int height, int flags);
	public static final native String GetWindowText(int handle);
	public static final native void SetWindowText(int handle, String text);
	public static final native void DestroyWindow(int handle);
	public static final native void EnableWindow(int handle, boolean enable);
	public static final native void BringWindowToTop(int handle);
	public static final native int FindWindow(String className, String windowTitle);
	public static final native void ShowWindow(int handle, int flags);
	public static final native void SetForegroundWindow(int handle);
	public static final native int GetWindowX(int handle);
	public static final native int GetWindowY(int handle);
//	public static final native int GetWindowWidth(int handle);
	public static final native int GetWindowHeight(int handle);
	public static final native int PostMessage(int hwnd, int msg, int wParam, int lParam);
	public static final native void InvalidateRect(int hwnd, boolean erase);
//	public static final native void RedrawWindow(int hwnd, int x, int y, int w, int h, int flags);
//	public static final native int GetScrollPos(int hwnd);
	public static final native void InsertMenu(int handle, int index, int flags, int id, String label);
	public static final native int RemoveMenu(int handle, int index, int flags);
	public static final native void DrawMenuBar(int handle);
	public static final native void DestroyMenu(int menuHandle);
	public static final native void CommandBar_Destroy(int handle);
	public static final native int CreatePopupMenu();
	public static final native void AddSubMenu(int handle, int menuHandle, int index, int id, String label);
	public static final native void RemoveSubMenu(int handle, int menuHandle, int index);
//	public static final native void RemoveSubMenus(int handle);
	public static final native int GetClientWidth(int handle);
	public static final native int GetClientHeight(int handle);
	public static final native int SendMessageW(int handle, int msg, int arg1, int arg2);
	public static final native int SendMessageW(int handle, int msg, int arg1, String arg2);
	public static final native int SendMessageW(int handle, int msg, int[] arg1, int[] arg2);
	public static final native int SendMessageW(int handle, int msg, int arg1, short[] arg2);
	public static final native void SetFocus(int handle);
	public static final native int GetFocus();
	public static final native void MessageBeep(int sound);
	public static final native int DateTime_GetSystemTime(int handle, int[] retValue);

	public static final native void GetWindowDimensions(int handle, int[] retValues);
	public static final native int CreateChildWindow(int hwnd, int flags);

//	public static final native void DeleteObject(int object);

	public static final native void SetButtonInfo(int handle, int id, String text);

	//	PocketPC and Smartphone 2002 only
//	 public static final int MOD_WIN = 0x0008; // winuser.h
//	 public static final int MOD_KEYUP = 0x1000; // winuser.h

	//	Smartphone back key handling
	 public static final native void SHSendBackToFocusWindow(int msg, int wParam, int lParam);
	 public static final native void SHNavigateBack();

	/*
	 * The first time this method called, pass a zero to dllHandle to force
	 * the phone dll to be loaded.  Every other time, pass the value of this
	 * handle which was returned from the first call.  If the dll could not
	 * be loaded the first time, a -1 is returned.  Every other time, the
	 * return value will be the handle which was passed in.
	 */
//	public static final native boolean Vibrate(int id, int milliseconds); // SP only
	public static final native boolean Vibrate(); // SP and PPC only
	public static final native void VibrateStop(); // SP and PPC only
	public static final native void FlashBacklight(); // SP and PPC only
	public static final native void FlashBacklightStop(); // SP and PPC only
	public static final native void Edit_SetInputMode(int handle, int mode); // SP only

	public static final native int GetMenuBarSize();

	/*
	* Flags for Window API GetVersionEx
	*/
//	public static final int VER_PLATFORM_WIN32s = 0;
//	public static final int VER_PLATFORM_WIN32_WINDOWS = 1;
//	public static final int VER_PLATFORM_WIN32_NT = 2;
//	public static final int VER_PLATFORM_WIN32_CE = 3;

	/* Flag used on WinCE */
	static final int SYS_COLOR_INDEX_FLAG = OS.IsWinCE ? 0x40000000 : 0x0;

	/*
	* NOTE:  There is a bug in JVM 1.2 where loading
	* a class with a large number of constants causes
	* a segment fault to occur sometime later after
	* the class is loaded.  The fix is to break the
	* class up into a hierarchy of classes that each
	* contain a smaller number of constants.  This
	* fix is not necessary at this time but is required
	* when all constants are uncommented.  We have not
	* done the research to determine the limit.
	*/

	/* Constants */
//	public static final int BFFM_INITIALIZED = 0x1;
//	public static final int BFFM_SETSELECTION = IsUnicode ? 0x467 : 0x466;
//	public static final int BFFM_VALIDATEFAILED = IsUnicode ? 0x4 : 0x3;
//	public static final int BFFM_VALIDATEFAILEDW = 0x4;
//	public static final int BFFM_VALIDATEFAILEDA = 0x3;
//	public static final int BF_BOTTOM = 0x8;
//	public static final int BF_RIGHT = 0x4;
//	public static final int BIF_EDITBOX = 0x10;
//	public static final int BIF_NEWDIALOGSTYLE = 0x40;
//	public static final int BIF_RETURNONLYFSDIRS = 0x1;
//	public static final int BIF_VALIDATE = 0x20;
//	public static final int BITSPIXEL = 0xc;
//	public static final int BLACKNESS = 0x42;
//	public static final int BM_CLICK = 0xf5;
//	public static final int BM_GETCHECK = 0xf0;
//	public static final int BM_SETCHECK = 0xf1;
//	public static final int BM_SETIMAGE = 0xf7;
//	public static final int BM_SETSTYLE = 0xf4;
//	public static final int BN_CLICKED = 0x0;
//	public static final int BN_DOUBLECLICKED = 0x5;
//	public static final int BST_CHECKED = 0x1;
//	public static final int BST_UNCHECKED = 0x0;
//	public static final int BS_BITMAP = 0x80;
//	public static final int BS_CENTER = 0x300;
//	public static final int BS_CHECKBOX = 0x2;
//	public static final int BS_DEFPUSHBUTTON = 0x1;
//	public static final int BS_FLAT = 0x8000;
//	public static final int BS_GROUPBOX = 0x7;
//	public static final int BS_ICON = 0x40;
//	public static final int BS_LEFT = 0x100;
//	public static final int BS_NOTIFY = 0x4000;
//	public static final int BS_OWNERDRAW = 0xb;
//	public static final int BS_PUSHBUTTON = 0x0;
//	public static final int BS_PUSHLIKE = 0x1000;
//	public static final int BS_RADIOBUTTON = 0x4;
//	public static final int BS_RIGHT = 0x200;
//	public static final int BS_SOLID = 0x0;
//	public static final int BTNS_AUTOSIZE = 0x10;
//	public static final int BTNS_BUTTON = 0x0;
//	public static final int BTNS_CHECK = 0x2;
//	public static final int BTNS_CHECKGROUP = 0x6;
//	public static final int BTNS_DROPDOWN = 0x8;
//	public static final int BTNS_GROUP = 0x4;
//	public static final int BTNS_SEP = 0x1;
//	public static final int CBN_EDITCHANGE = 0x5;
//	public static final int CBN_KILLFOCUS = 0x4;
	public static final int CBN_SELCHANGE = 0x1;
//	public static final int CBN_SETFOCUS = 0x3;
	public static final int CBN_CLOSEUP = 0x8;
	public static final int CBS_AUTOHSCROLL = 0x40;
//	public static final int CBS_DROPDOWN = 0x2;
	public static final int CBS_DROPDOWNLIST = 0x3;
	public static final int CBS_NOINTEGRALHEIGHT = 0x400;
//	public static final int CBS_SIMPLE = 0x1;
	public static final int CB_ADDSTRING = 0x143;
	public static final int CB_DELETESTRING = 0x144;
//	public static final int CB_ERR = 0xffffffff;
//	public static final int CB_ERRSPACE = 0xfffffffe;
//	public static final int CB_FINDSTRINGEXACT = 0x158;
//	public static final int CB_GETCOUNT = 0x146;
	public static final int CB_GETCURSEL = 0x147;
//	public static final int CB_GETDROPPEDCONTROLRECT = 0x152;
	public static final int CB_GETDROPPEDSTATE = 0x157;
//	public static final int CB_GETEDITSEL = 0x140;
//	public static final int CB_GETITEMHEIGHT = 0x154;
//	public static final int CB_GETLBTEXT = 0x148;
//	public static final int CB_GETLBTEXTLEN = 0x149;
	public static final int CB_INSERTSTRING = 0x14a;
//	public static final int CB_LIMITTEXT = 0x141;
	public static final int CB_RESETCONTENT = 0x14b;
//	public static final int CB_SELECTSTRING = 0x14d;
	public static final int CB_SETCURSEL = 0x14e;
//	public static final int CB_SETEDITSEL = 0x142;
	public static final int CB_SHOWDROPDOWN = 0x14f;
	public static final int CB_SETHORIZONTALEXTENT = 0x15e;
//	public static final int CCM_FIRST = 0x2000;
//	public static final int CCM_SETBKCOLOR = 0x2001;
//	public static final int CCS_NODIVIDER = 0x40;
//	public static final int CCS_NORESIZE = 0x4;
//	public static final int CC_ANYCOLOR = 0x100;
//	public static final int CC_ENABLEHOOK = 0x10;
//	public static final int CC_RGBINIT = 0x1;
//	public static final int CDDS_PREPAINT = 0x00000001;
//	public static final int CDDS_ITEM = 0x00010000;
//	public static final int CDDS_ITEMPREPAINT = CDDS_ITEM | CDDS_PREPAINT;
//	public static final int CDDS_SUBITEM = 0x00020000;
//	public static final int CDRF_DODEFAULT = 0x00000000;
//	public static final int CDRF_NEWFONT = 0x00000002;
//	public static final int CDRF_NOTIFYITEMDRAW = 0x00000020;
//	public static final int CDRF_NOTIFYSUBITEMDRAW = 0x00000020;
//	public static final int CFE_AUTOCOLOR = 0x40000000;
//	public static final int CFE_ITALIC = 0x2;
//	public static final int CFE_STRIKEOUT = 0x8;
//	public static final int CFE_UNDERLINE = 0x4;
//	public static final int CFM_BOLD = 0x1;
//	public static final int CFM_CHARSET = 0x8000000;
//	public static final int CFM_COLOR = 0x40000000;
//	public static final int CFM_FACE = 0x20000000;
//	public static final int CFM_ITALIC = 0x2;
//	public static final int CFM_SIZE = 0x80000000;
//	public static final int CFM_STRIKEOUT = 0x8;
//	public static final int CFM_UNDERLINE = 0x4;
//	public static final int CFM_WEIGHT = 0x400000;
//	public static final int CFS_POINT = 0x2;
//	public static final int CF_EFFECTS = 0x100;
//	public static final int CF_INITTOLOGFONTSTRUCT = 0x40;
//	public static final int CF_SCREENFONTS = 0x1;
//	public static final int CF_TEXT = 0x1;
//	public static final int CF_UNICODETEXT = 13;
//	public static final int CF_USESTYLE = 0x80;
//	public static final int CLR_DEFAULT = 0xff000000;
//	public static final int CLR_INVALID = 0xffffffff;
//	public static final int COLORONCOLOR = 0x3;
//	public static final int COLOR_3DDKSHADOW = 0x15 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_3DFACE = 0xf | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_3DHIGHLIGHT = 0x14 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_3DHILIGHT = 0x14 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_3DLIGHT = 0x16 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_3DSHADOW = 0x10 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_ACTIVECAPTION = 0x2 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_BTNFACE = 0xf | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_BTNHIGHLIGHT = 0x14 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_BTNSHADOW = 0x10 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_BTNTEXT = 0x12 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_CAPTIONTEXT = 0x9 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_GRADIENTACTIVECAPTION = 0x1b | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_GRADIENTINACTIVECAPTION = 0x1c | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_HIGHLIGHT = 0xd | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_HIGHLIGHTTEXT = 0xe | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_INACTIVECAPTION = 0x3 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_INACTIVECAPTIONTEXT = 0x13 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_INFOBK = 0x18 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_INFOTEXT = 0x17 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_MENU = 0x4 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_MENUTEXT = 0x7 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_SCROLLBAR = 0x0 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_WINDOW = 0x5 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_WINDOWFRAME = 0x6 | SYS_COLOR_INDEX_FLAG;
//	public static final int COLOR_WINDOWTEXT = 0x8 | SYS_COLOR_INDEX_FLAG;
//	public static final int COMPLEXREGION = 0x3;
//	public static final int CP_ACP = 0x0;
//	public static final int CP_INSTALLED = 0x1;
//	public static final int CS_BYTEALIGNWINDOW = 0x2000;
//	public static final int CS_DBLCLKS = 0x8;
//	public static final int CS_HREDRAW = 0x2;
//	public static final int CS_VREDRAW = 0x1;
//	public static final int CW_USEDEFAULT = 0x80000000;
//	public static final int DCX_CACHE = 0x2;
//	public static final int DCX_CLIPCHILDREN = 0x8;
//	public static final int DCX_CLIPSIBLINGS = 0x10;
//	public static final int DEFAULT_CHARSET = 0x1;
//	public static final int DEFAULT_GUI_FONT = 0x11;
//	public static final int DFCS_BUTTONCHECK = 0x0;
//	public static final int DFCS_CHECKED = 0x400;
//	public static final int DFCS_FLAT = 0x4000;
//	public static final int DFCS_INACTIVE = 0x100;
//	public static final int DFCS_PUSHED = 0x200;
//	public static final int DFCS_SCROLLDOWN = 0x1;
//	public static final int DFCS_SCROLLLEFT = 0x2;
//	public static final int DFCS_SCROLLRIGHT = 0x3;
//	public static final int DFCS_SCROLLUP = 0x0;
//	public static final int DFC_BUTTON = 0x4;
//	public static final int DFC_SCROLL = 0x3;
//	public static final int DIB_RGB_COLORS = 0x0;
//	public static final int DISP_E_EXCEPTION = 0x80020009;
//	public static final int DI_NORMAL = 0x3;
//	public static final int DLGC_BUTTON = 0x2000;
//	public static final int DLGC_STATIC = 0x100;
//	public static final int DLGC_WANTALLKEYS = 0x4;
//	public static final int DLGC_WANTARROWS = 0x1;
//	public static final int DLGC_WANTTAB = 0x2;
//	public static final int DM_SETDEFID = OS.WM_USER + 1;
//	public static final int DSS_DISABLED = 0x20;
//	public static final int DSTINVERT = 0x550009;
//	public static final int DST_BITMAP = 0x4;
//	public static final int DST_ICON = 0x3;
//	public static final int DT_CALCRECT = 0x400;
//	public static final int DT_EDITCONTROL = 0x2000;
//	public static final int DT_EXPANDTABS = 0x40;
//	public static final int DT_LEFT = 0x0;
//	public static final int DT_NOPREFIX = 0x800;
//	public static final int DT_SINGLELINE = 0x20;
//	public static final int DT_WORDBREAK = 0x10;
	public static final int DTM_FIRST = 0x1000;
	public static final int DTM_SETSYSTEMTIME = DTM_FIRST + 2;
	public static final int DTM_GETMONTHCAL = DTM_FIRST + 8;
//	public static final int DTM_GETSYSTEMTIME = DTM_FIRST + 1;
	public static final int DTM_SETFORMATW = DTM_FIRST + 50;
//	public static final int DTN_FIRST = 0x12efab;
//	public static final int DTN_DATETIMECHANGE = DTN_FIRST + 1;
	public static final int DTS_TIMEFORMAT = 0x0009;
	public static final int DTS_SHORTDATEFORMAT = 0x0000;
//	public static final int DTS_SHOWNONE = 0x0002;
//	public static final int ECOOP_AND = 0x3;
//	public static final int ECOOP_OR = 0x2;
//	public static final int ECO_AUTOHSCROLL = 0x80;
//	public static final int EDGE_ETCHED = 0x6;
//	public static final int EDGE_SUNKEN = 0xa;
//	public static final int EM_CANUNDO = 0xc6;
//	public static final int EM_CHARFROMPOS = 0xd7;
//	public static final int EM_DISPLAYBAND = 0x433;
//	public static final int EM_GETFIRSTVISIBLELINE = 0xce;
//	public static final int EM_GETLIMITTEXT = 0xd5;
//	public static final int EM_GETLINE = 0xc4;
//	public static final int EM_GETLINECOUNT = 0xba;
//	public static final int EM_GETMARGINS = 0xd4;
//	public static final int EM_GETPASSWORDCHAR = 0xd2;
//	public static final int EM_GETRECT = 0xb2;
//	public static final int EM_GETSCROLLPOS = 0x4dd;
	public static final int EM_GETSEL = 0xb0;
//	public static final int EM_LIMITTEXT = 0xc5;
//	public static final int EM_LINEFROMCHAR = 0xc9;
//	public static final int EM_LINEINDEX = 0xbb;
//	public static final int EM_LINELENGTH = 0xc1;
//	public static final int EM_LINESCROLL = 0xb6;
//	public static final int EM_POSFROMCHAR = 0xd6;
//	public static final int EM_REPLACESEL = 0xc2;
//	public static final int EM_SCROLLCARET = 0xb7;
//	public static final int EM_SETBKGNDCOLOR = 0x443;
	public static final int EM_SETLIMITTEXT = 0xc5;
//	public static final int EM_SETOPTIONS = 0x44d;
//	public static final int EM_SETPARAFORMAT = 0x447;
	public static final int EM_SETPASSWORDCHAR = 0xcc;
	public static final int EM_SETREADONLY = 0xcf;
	public static final int EM_SETSEL = 0xb1;
//	public static final int EM_SETTABSTOPS = 0xcb;
//	public static final int EN_CHANGE = 0x300;
//	public static final int ERROR_NO_MORE_ITEMS = 0x103;
//	public static final int ESB_DISABLE_BOTH = 0x3;
//	public static final int ESB_ENABLE_BOTH = 0x0;
	public static final int ES_AUTOVSCROLL = 0x40;
	public static final int ES_AUTOHSCROLL = 0x80;
//	public static final int ES_CENTER = 0x1;
	public static final int ES_MULTILINE = 0x4;
	public static final int ES_NOHIDESEL = 0x100;
//	public static final int ES_READONLY = 0x800;
//	public static final int ES_RIGHT = 0x2;
	public static final int ES_NUMBER = 0x2000;
//	public static final int FALT = 0x10;
//	public static final int FCONTROL = 0x8;
//	public static final int FNERR_INVALIDFILENAME = 0x3002;
//	public static final int FSHIFT = 0x4;
//	public static final int FVIRTKEY = 0x1;
//	public static final int GCS_COMPSTR = 0x8;
//	public static final int GCS_RESULTSTR = 0x800;
//	public static final int GMDI_USEDISABLED = 0x1;
//	public static final int GMEM_FIXED = 0x0;
//	public static final int GMEM_ZEROINIT = 0x40;
//	public static final int GPTR = 0x40;
//	public static final int GRADIENT_FILL_RECT_H = 0x0;
//	public static final int GRADIENT_FILL_RECT_V = 0x1;
//	public static final int GTL_NUMBYTES = 0x10;
//	public static final int GTL_NUMCHARS = 0x8;
//	public static final int GTL_PRECISE = 0x2;
//	public static final int GT_DEFAULT = 0x0;
//	public static final int GWL_EXSTYLE = 0xffffffec;
//	public static final int GWL_ID = -12;
//	public static final int GWL_STYLE = 0xfffffff0;
//	public static final int GWL_USERDATA = 0xffffffeb;
//	public static final int GWL_WNDPROC = 0xfffffffc;
//	public static final int GW_CHILD = 0x5;
//	public static final int GW_HWNDFIRST = 0x0;
//	public static final int GW_HWNDLAST = 0x1;
//	public static final int GW_HWNDNEXT = 0x2;
//	public static final int GW_HWNDPREV = 0x3;
//	public static final int HBMMENU_CALLBACK = 0xffffffff;
//	public static final int HDI_WIDTH = 0x1;
//	public static final int HDM_FIRST = 0x1200;
//	public static final int HDM_GETBITMAPMARGIN = HDM_FIRST + 21;
//	public static final int HDM_GETITEMCOUNT = 0x1200;
//	public static final int HDN_BEGINTRACK = IsUnicode ? 0xfffffeba : 0xfffffece;
//	public static final int HDN_BEGINTRACKW = 0xfffffeba;
//	public static final int HDN_BEGINTRACKA = 0xfffffece;
//	public static final int HDN_FIRST = 0xfffffed4;
//	public static final int HDN_ITEMCHANGED = IsUnicode ? 0xfffffebf : 0xfffffed3;
//	public static final int HDN_ITEMCHANGEDW = 0xfffffebf;
//	public static final int HDN_ITEMCHANGEDA = 0xfffffed3;
//	public static final int HEAP_ZERO_MEMORY = 0x8;
//	public static final int HELPINFO_MENUITEM = 0x2;
//	public static final int HINST_COMMCTRL = 0xffffffff;
//	public static final int HKEY_CLASSES_ROOT = 0x80000000;
//	public static final int HKEY_CURRENT_USER = 0x80000001;
//	public static final int HORZRES = 0x8;
//	public static final int HTBORDER = 0x12;
//	public static final int HTCLIENT = 0x1;
//	public static final int HTERROR = -2;
//	public static final int HTHSCROLL = 0x6;
//	public static final int HTMENU = 0x5;
//	public static final int HTNOWHERE = 0x0;
//	public static final int HTTRANSPARENT = 0xffffffff;
//	public static final int HTVSCROLL = 0x7;
//	public static final int HWND_BOTTOM = 0x1;
//	public static final int HWND_TOP = 0x0;
//	public static final int HWND_TOPMOST = 0xffffffff;
//	public static final int HWND_NOTOPMOST = -2;
//	public static final int ICC_COOL_CLASSES = 0x400;
//	public static final int ICM_NOTOPEN = 0x0;
//	public static final int ICON_BIG = 0x1;
//	public static final int ICON_SMALL = 0x0;
//	public static final int I_IMAGENONE = -2;
//	public static final int IDABORT = 0x3;
//	public static final int IDB_STD_SMALL_COLOR = 0x0;
//	public static final int IDC_APPSTARTING = 0x7f8a;
//	public static final int IDC_ARROW = 0x7f00;
//	public static final int IDC_CROSS = 0x7f03;
//	public static final int IDC_HAND = 0x7f89;
//	public static final int IDC_HELP = 0x7f8b;
//	public static final int IDC_IBEAM = 0x7f01;
//	public static final int IDC_NO = 0x7f88;
//	public static final int IDC_SIZE = 0x7f80;
//	public static final int IDC_SIZEALL = 0x7f86;
//	public static final int IDC_SIZENESW = 0x7f83;
//	public static final int IDC_SIZENS = 0x7f85;
//	public static final int IDC_SIZENWSE = 0x7f82;
//	public static final int IDC_SIZEWE = 0x7f84;
//	public static final int IDC_UPARROW = 0x7f04;
//	public static final int IDC_WAIT = 0x7f02;
//	public static final int IDI_WINLOGO = 0x7f05;
//	public static final int IDNO = 0x7;
//	public static final int IDOK = 0x1;
//	public static final int IDRETRY = 0x4;
//	public static final int IDYES = 0x6;
//	public static final int ILC_COLOR = 0x0;
//	public static final int ILC_COLOR16 = 0x10;
//	public static final int ILC_COLOR24 = 0x18;
//	public static final int ILC_COLOR32 = 0x20;
//	public static final int ILC_COLOR4 = 0x4;
//	public static final int ILC_COLOR8 = 0x8;
//	public static final int ILC_MASK = 0x1;
//	public static final int ILD_NORMAL = 0x0;
//	public static final int IMAGE_BITMAP = 0x0;
//	public static final int IMAGE_CURSOR = 0x2;
//	public static final int IMAGE_ICON = 0x1;
//	public static final int IME_CMODE_FULLSHAPE = 0x8;
//	public static final int IME_CMODE_KATAKANA = 0x2;
//	public static final int IME_CMODE_NATIVE = 0x1;
//	public static final int IME_CMODE_ROMAN = 0x10;
//	public static final int INFINITE = 0xffffffff;
//	public static final int KEY_ENUMERATE_SUB_KEYS = 0x8;
//	public static final int KEY_NOTIFY = 0x10;
//	public static final int KEY_QUERY_VALUE = 0x1;
//	public static final int KEY_READ = 0x20019;
//	public static final int LBN_DBLCLK = 0x2;
//	public static final int LBN_SELCHANGE = 0x1;
//	public static final int LBS_EXTENDEDSEL = 0x800;
//	public static final int LBS_MULTIPLESEL = 0x8;
//	public static final int LBS_NOINTEGRALHEIGHT = 0x100;
//	public static final int LBS_NOTIFY = 0x1;
//	public static final int LB_ADDSTRING = 0x180;
//	public static final int LB_DELETESTRING = 0x182;
//	public static final int LB_ERR = 0xffffffff;
//	public static final int LB_ERRSPACE = 0xfffffffe;
//	public static final int LB_FINDSTRINGEXACT = 0x1a2;
//	public static final int LB_GETCARETINDEX = 0x19f;
//	public static final int LB_GETCOUNT = 0x18b;
//	public static final int LB_GETCURSEL = 0x188;
//	public static final int LB_GETHORIZONTALEXTENT = 0x193;
//	public static final int LB_GETITEMHEIGHT = 0x1a1;
//	public static final int LB_GETITEMRECT = 0x198;
//	public static final int LB_GETSEL = 0x187;
//	public static final int LB_GETSELCOUNT = 0x190;
//	public static final int LB_GETSELITEMS = 0x191;
//	public static final int LB_GETTEXT = 0x189;
//	public static final int LB_GETTEXTLEN = 0x18a;
//	public static final int LB_GETTOPINDEX = 0x18e;
//	public static final int LB_INITSTORAGE = 0x1a8;
//	public static final int LB_INSERTSTRING = 0x181;
//	public static final int LB_RESETCONTENT = 0x184;
//	public static final int LB_SELITEMRANGE = 0x19b;
//	public static final int LB_SELITEMRANGEEX = 0x183;
//	public static final int LB_SETCARETINDEX = 0x19e;
//	public static final int LB_SETCURSEL = 0x186;
//	public static final int LB_SETHORIZONTALEXTENT = 0x194;
//	public static final int LB_SETSEL = 0x185;
//	public static final int LB_SETTOPINDEX = 0x197;
//	public static final int LCID_SUPPORTED = 0x2;
//	public static final int LOCALE_IDEFAULTANSICODEPAGE = 0x1004;
//	public static final int LOCALE_SISO3166CTRYNAME = 0x5a;
//	public static final int LOCALE_SISO639LANGNAME = 0x59;
//	public static final int LOGPIXELSX = 0x58;
//	public static final int LOGPIXELSY = 0x5a;
//	public static final int LPSTR_TEXTCALLBACK = 0xffffffff;
//	public static final int LR_DEFAULTCOLOR = 0x0;
//	public static final int LVCFMT_CENTER = 0x2;
//	public static final int LVCFMT_IMAGE = 0x800;
//	public static final int LVCFMT_LEFT = 0x0;
//	public static final int LVCFMT_RIGHT = 0x1;
//	public static final int LVCF_FMT = 0x1;
//	public static final int LVCF_IMAGE = 0x10;
//	public static final int LVCF_TEXT = 0x4;
//	public static final int LVCF_WIDTH = 0x2;
//	public static final int LVHT_ONITEM = 0xe;
//	public static final int LVHT_ONITEMICON = 0x2;
//	public static final int LVHT_ONITEMLABEL = 0x4;
//	public static final int LVHT_ONITEMSTATEICON = 0x8;
//	public static final int LVIF_IMAGE = 0x2;
//	public static final int LVIF_INDENT = 0x10;
//	public static final int LVIF_STATE = 0x8;
//	public static final int LVIF_TEXT = 0x1;
//	public static final int LVIR_BOUNDS = 0x0;
//	public static final int LVIR_ICON = 0x1;
//	public static final int LVIR_LABEL = 0x2;
//	public static final int LVIS_DROPHILITED = 0x8;
//	public static final int LVIS_FOCUSED = 0x1;
//	public static final int LVIS_SELECTED = 0x2;
//	public static final int LVIS_STATEIMAGEMASK = 0xf000;
//	public static final int LVM_APPROXIMATEVIEWRECT = 0x1040;
//	public static final int LVM_DELETEALLITEMS = 0x1009;
//	public static final int LVM_DELETECOLUMN = 0x101c;
//	public static final int LVM_DELETEITEM = 0x1008;
//	public static final int LVM_ENSUREVISIBLE = 0x1013;
//	public static final int LVM_FIRST = 0x1000;
//	public static final int LVM_GETBKCOLOR = 0x1000;
//	public static final int LVM_GETCOLUMN = IsUnicode ? 0x105f : 0x1019;
//	public static final int LVM_GETCOLUMNWIDTH = 0x101d;
//	public static final int LVM_GETCOUNTPERPAGE = 0x1028;
//	public static final int LVM_GETEXTENDEDLISTVIEWSTYLE = 0x1037;
//	public static final int LVM_GETHEADER = 0x101f;
//	public static final int LVM_GETIMAGELIST = 0x1002;
//	public static final int LVM_GETITEM = IsUnicode ? 0x104b : 0x1005;
//	public static final int LVM_GETITEMW = 0x104b;
//	public static final int LVM_GETITEMA = 0x1005;
//	public static final int LVM_GETITEMCOUNT = 0x1004;
//	public static final int LVM_GETITEMRECT = 0x100e;
//	public static final int LVM_GETITEMSTATE = 0x102c;
//	public static final int LVM_GETNEXTITEM = 0x100c;
//	public static final int LVM_GETSELECTEDCOUNT = 0x1032;
//	public static final int LVM_GETSTRINGWIDTH = IsUnicode ? 0x1057 : 0x1011;
//	public static final int LVM_GETSUBITEMRECT = 0x1038;
//	public static final int LVM_GETTEXTCOLOR = 0x1023;
//	public static final int LVM_GETTOPINDEX = 0x1027;
//	public static final int LVM_HITTEST = 0x1012;
//	public static final int LVM_INSERTCOLUMN = IsUnicode ? 0x1061 : 0x101b;
//	public static final int LVM_INSERTITEM = IsUnicode ? 0x104d : 0x1007;
//	public static final int LVM_SCROLL = 0x1014;
//	public static final int LVM_SETBKCOLOR = 0x1001;
//	public static final int LVM_SETCOLUMN = IsUnicode ? 0x1060 : 0x101a;
//	public static final int LVM_SETCOLUMNWIDTH = 0x101e;
//	public static final int LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036;
//	public static final int LVM_SETIMAGELIST = 0x1003;
//	public static final int LVM_SETITEM = IsUnicode ? 0x104c : 0x1006;
//	public static final int LVM_SETITEMSTATE = 0x102b;
//	public static final int LVM_SETTEXTBKCOLOR = 0x1026;
//	public static final int LVM_SETTEXTCOLOR = 0x1024;
//	public static final int LVNI_FOCUSED = 0x1;
//	public static final int LVNI_SELECTED = 0x2;
//	public static final int LVN_BEGINDRAG = 0xffffff93;
//	public static final int LVN_BEGINRDRAG = 0xffffff91;
//	public static final int LVN_COLUMNCLICK = 0xffffff94;
//	public static final int LVN_FIRST = 0xffffff9c;
//	public static final int LVN_ITEMACTIVATE = 0xffffff8e;
//	public static final int LVN_ITEMCHANGED = 0xffffff9b;
//	public static final int LVN_MARQUEEBEGIN = 0xffffff64;
//	public static final int LVSCW_AUTOSIZE = 0xffffffff;
//	public static final int LVSCW_AUTOSIZE_USEHEADER = 0xfffffffe;
//	public static final int LVSIL_SMALL = 0x1;
//	public static final int LVSIL_STATE = 0x2;
//	public static final int LVS_EX_FULLROWSELECT = 0x20;
//	public static final int LVS_EX_GRIDLINES = 0x1;
//	public static final int LVS_EX_LABELTIP = 0x4000;
//	public static final int LVS_EX_ONECLICKACTIVATE = 0x40;
//	public static final int LVS_EX_SUBITEMIMAGES = 0x2;
//	public static final int LVS_EX_TRACKSELECT = 0x8;
//	public static final int LVS_EX_TWOCLICKACTIVATE = 0x80;
//	public static final int LVS_NOCOLUMNHEADER = 0x4000;
//	public static final int LVS_NOSCROLL = 0x2000;
//	public static final int LVS_REPORT = 0x1;
//	public static final int LVS_SHAREIMAGELISTS = 0x40;
//	public static final int LVS_SHOWSELALWAYS = 0x8;
//	public static final int LVS_SINGLESEL = 0x4;
//	public static final int MA_NOACTIVATE = 0x3;
//	public static final int MB_ABORTRETRYIGNORE = 0x2;
//	public static final int MB_APPLMODAL = 0x0;
//	public static final int MB_ICONERROR = 0x10;
//	public static final int MB_ICONINFORMATION = 0x40;
	public static final int MB_ICONQUESTION = 0x20;
//	public static final int MB_ICONWARNING = 0x30;
	public static final int MB_OK = 0x0;
//	public static final int MB_OKCANCEL = 0x1;
//	public static final int MB_PRECOMPOSED = 0x1;
//	public static final int MB_RETRYCANCEL = 0x5;
//	public static final int MB_SYSTEMMODAL = 0x1000;
//	public static final int MB_TASKMODAL = 0x2000;
//	public static final int MB_YESNO = 0x4;
//	public static final int MB_YESNOCANCEL = 0x3;
//	public static final int MFS_CHECKED = 0x8;
//	public static final int MFS_DISABLED = 0x3;
//	public static final int MFS_GRAYED = 0x3;
//	public static final int MFT_RADIOCHECK = 0x200;
//	public static final int MFT_SEPARATOR = 0x800;
//	public static final int MFT_STRING = 0x0;
//	public static final int MF_BYCOMMAND = 0x0;
	public static final int MF_BYPOSITION = 0x400;
//	public static final int MF_CHECKED = 0x8;
//	public static final int MF_DISABLED = 0x2;
//	public static final int MF_ENABLED = 0x0;
//	public static final int MF_GRAYED = 0x1;
//	public static final int MF_HILITE = 0x80;
	public static final int MF_POPUP = 0x10;
//	public static final int MF_SEPARATOR = 0x800;
//	public static final int MF_SYSMENU = 0x2000;
//	public static final int MF_UNCHECKED = 0x0;
//	public static final int MIIM_BITMAP = 0x80;
//	public static final int MIIM_DATA = 0x20;
//	public static final int MIIM_ID = 0x2;
//	public static final int MIIM_STATE = 0x1;
//	public static final int MIIM_SUBMENU = 0x4;
//	public static final int MIIM_TYPE = 0x10;
//	public static final int MIM_STYLE = 0x10;
//	public static final int MK_CONTROL = 0x8;
//	public static final int MK_LBUTTON = 0x1;
//	public static final int MK_MBUTTON = 0x10;
//	public static final int MK_RBUTTON = 0x2;
//	public static final int MK_SHIFT = 0x4;
//	public static final int MM_TEXT = 0x1;
//	public static final int MNC_CLOSE = 0x1;
//	public static final int MNS_CHECKORBMP = 0x4000000;
//	public static final int MWMO_INPUTAVAILABLE = 0x4;
//	public static final int NM_CLICK = 0xfffffffe;
//	public static final int NM_CUSTOMDRAW = OS.NM_FIRST - 12;
//	public static final int NM_DBLCLK = 0xfffffffd;
//	public static final int NM_FIRST = 0x0;
//	public static final int NM_RETURN = 0xfffffffc;
//	public static final int NOTSRCCOPY = 0x330008;
//	public static final int NULLREGION = 0x1;
//	public static final int NULL_BRUSH = 0x5;
//	public static final int NULL_PEN = 0x8;
//	public static final int OBJID_CLIENT = 0xFFFFFFFC;
//	public static final int OBJ_FONT = 0x6;
//	public static final int OBJ_PEN = 0x1;
//	public static final int OBM_CHECKBOXES = 0x7ff7;
//	public static final int ODS_SELECTED = 0x1;
//	public static final int ODT_MENU = 0x1;
//	public static final int OFN_ALLOWMULTISELECT = 0x200;
//	public static final int OFN_EXPLORER = 0x80000;
//	public static final int OFN_HIDEREADONLY = 0x4;
//	public static final int OFN_NOCHANGEDIR = 0x8;
//	public static final int OPAQUE = 0x2;
//	public static final int PATCOPY = 0xf00021;
//	public static final int PATINVERT = 0x5a0049;
//	public static final int PBM_GETPOS = 0x408;
//	public static final int PBM_GETRANGE = 0x407;
//	public static final int PBM_SETBARCOLOR = 0x409;
//	public static final int PBM_SETBKCOLOR = 0x2001;
//	public static final int PBM_SETPOS = 0x402;
//	public static final int PBM_SETRANGE32 = 0x406;
//	public static final int PBS_SMOOTH = 0x1;
//	public static final int PBS_VERTICAL = 0x4;
//	public static final int PD_ALLPAGES = 0x0;
//	public static final int PD_COLLATE = 0x10;
//	public static final int PD_PAGENUMS = 0x2;
//	public static final int PD_PRINTTOFILE = 0x20;
//	public static final int PD_RETURNDC = 0x100;
//	public static final int PD_SELECTION = 0x1;
//	public static final int PD_USEDEVMODECOPIESANDCOLLATE = 0x40000;
//	public static final int PFM_TABSTOPS = 0x10;
//	public static final int PHYSICALHEIGHT = 0x6f;
//	public static final int PHYSICALOFFSETX = 0x70;
//	public static final int PHYSICALOFFSETY = 0x71;
//	public static final int PHYSICALWIDTH = 0x6e;
//	public static final int PLANES = 0xe;
//	public static final int PM_REMOVE = 0x1;
//	public static final String PROGRESS_CLASS = "msctls_progress32"; //$NON-NLS-1$
//	public static final int PS_DASH = 0x1;
//	public static final int PS_DASHDOT = 0x3;
//	public static final int PS_DASHDOTDOT = 0x4;
//	public static final int PS_DOT = 0x2;
//	public static final int PS_ENDCAP_FLAT = 0x200;
//	public static final int PS_GEOMETRIC = 0x10000;
//	public static final int PS_JOIN_MITER = 0x2000;
//	public static final int PS_SOLID = 0x0;
//	public static final int PS_STYLE_MASK = 0xf;
//	public static final int QS_KEY = 0x0001;
//	public static final int QS_MOUSEMOVE = 0x0002;
//	public static final int QS_MOUSEBUTTON = 0x0004;
//	public static final int QS_POSTMESSAGE = 0x0008;
//	public static final int QS_TIMER = 0x0010;
//	public static final int QS_PAINT = 0x0020;
//	public static final int QS_SENDMESSAGE = 0x0040;
//	public static final int QS_ALLINPUT = QS_MOUSEMOVE | QS_MOUSEBUTTON | QS_KEY | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_SENDMESSAGE;
//	public static final int R2_COPYPEN = 0xd;
//	public static final int R2_XORPEN = 0x7;
//	public static final int RASTERCAPS = 0x26;
//	public static final int RASTER_FONTTYPE = 0x1;
//	public static final int RBBIM_CHILD = 0x10;
//	public static final int RBBIM_CHILDSIZE = 0x20;
//	public static final int RBBIM_COLORS = 0x2;
//	public static final int RBBIM_HEADERSIZE = 0x800;
//	public static final int RBBIM_ID = 0x100;
//	public static final int RBBIM_IDEALSIZE = 0x200;
//	public static final int RBBIM_SIZE = 0x40;
//	public static final int RBBIM_STYLE = 0x1;
//	public static final int RBBIM_TEXT = 0x4;
//	public static final int RBBS_BREAK = 0x1;
//	public static final int RBBS_GRIPPERALWAYS = 0x80;
//	public static final int RBBS_NOGRIPPER = 0x00000100;
//	public static final int RBBS_USECHEVRON = 0x00000200;
//	public static final int RBBS_VARIABLEHEIGHT = 0x40;
//	public static final int RBN_FIRST = 0xfffffcc1;
//	public static final int RBN_CHEVRONPUSHED = RBN_FIRST - 10;
//	public static final int RBN_HEIGHTCHANGE = 0xfffffcc1;
//	public static final int RBS_DBLCLKTOGGLE = 0x8000;
//	public static final int RBS_BANDBORDERS = 0x400;
//	public static final int RBS_VARHEIGHT = 0x200;
//	public static final int RB_DELETEBAND = 0x402;
//	public static final int RB_GETBANDBORDERS = 0x422;
//	public static final int RB_GETBANDCOUNT = 0x40c;
//	public static final int RB_GETBANDINFO = IsUnicode ? 0x41c : 0x41d;
//	public static final int RB_GETBARHEIGHT = 0x41b;
//	public static final int RB_GETBKCOLOR = 0x414;
//	public static final int RB_GETRECT = 0x409;
//	public static final int RB_GETTEXTCOLOR = 0x416;
//	public static final int RB_IDTOINDEX = 0x410;
//	public static final int RB_INSERTBAND = IsUnicode ? 0x40a : 0x401;
//	public static final int RB_MOVEBAND = 0x427;
//	public static final int RB_SETBANDINFO = IsUnicode ? 0x40b : 0x406;
//	public static final int RB_SETBKCOLOR = 0x413;
//	public static final int RB_SETTEXTCOLOR = 0x415;
//	public static final int RC_BITBLT = 0x1;
//	public static final int RC_PALETTE = 0x100;
//	public static final int RDW_ALLCHILDREN = 0x80;
//	public static final int RDW_ERASE = 0x4;
//	public static final int RDW_FRAME = 0x400;
//	public static final int RDW_INVALIDATE = 0x1;
//	public static final int RDW_UPDATENOW = 0x100;
//	public static final int READ_CONTROL = 0x20000;
//	public static final String REBARCLASSNAME = "ReBarWindow32"; //$NON-NLS-1$
//	public static final int RGN_OR = 0x2;
//	public static final int SBS_HORZ = 0x0;
//	public static final int SBS_VERT = 0x1;
//	public static final int SB_BOTTOM = 0x7;
//	public static final int SB_CTL = 0x2;
//	public static final int SB_ENDSCROLL = 0x8;
//	public static final int SB_HORZ = 0x0;
//	public static final int SB_LINEDOWN = 0x1;
//	public static final int SB_LINEUP = 0x0;
//	public static final int SB_PAGEDOWN = 0x3;
//	public static final int SB_PAGEUP = 0x2;
//	public static final int SB_THUMBPOSITION = 0x4;
//	public static final int SB_THUMBTRACK = 0x5;
//	public static final int SB_TOP = 0x6;
//	public static final int SB_VERT = 0x1;
//	public static final int SCF_ALL = 0x4;
//	public static final int SCF_DEFAULT = 0x0;
//	public static final int SCF_SELECTION = 0x1;
//	public static final int SC_CLOSE = 0xf060;
//	public static final int SC_HSCROLL = 0xf080;
//	public static final int SC_KEYMENU = 0xf100;
//	public static final int SC_MAXIMIZE = 0xf030;
//	public static final int SC_MINIMIZE = 0xf020;
//	public static final int SC_RESTORE = 0xf120;
//	public static final int SC_SIZE = 0xf000;
//	public static final int SC_TASKLIST = 0xf130;
//	public static final int SC_VSCROLL = 0xf070;
//	public static final int SF_RTF = 0x2;
//	public static final int SHCMBF_HIDDEN = 0x2;
//	public static final int SHCMBM_OVERRIDEKEY = OS.WM_USER + 403;
//	public static final int SHCMBM_SETSUBMENU = 0x590;
	public static final int SHCMBM_GETSUBMENU = 0x591;
//	public static final int SHMBOF_NODEFAULT = 0x1;
//	public static final int SHMBOF_NOTIFY = 0x2;
//	public static final int SIF_ALL = 0x17;
//	public static final int SIF_DISABLENOSCROLL = 0x8;
//	public static final int SIF_PAGE = 0x2;
//	public static final int SIF_POS = 0x4;
//	public static final int SIF_RANGE = 0x1;
//	public static final int SIF_TRACKPOS = 0x10;
	public static final int SIZE_MINIMIZED = 0x1;
//	public static final int SM_CMONITORS = 80;
//	public static final int SM_CXBORDER = 0x5;
//	public static final int SM_CXCURSOR = 0xd;
//	public static final int SM_CXEDGE = 0x2d;
//	public static final int SM_CXHSCROLL = 0x15;
//	public static final int SM_CXICON = 0x0b;
//	public static final int SM_CYICON = 0x0c;
//	public static final int SM_CXVIRTUALSCREEN = 78;
//	public static final int SM_CYVIRTUALSCREEN = 79;
//	public static final int SM_CXSMICON = 49;
//	public static final int SM_CYSMICON = 50;
//	public static final int SM_CXSCREEN = 0x0;
//	public static final int SM_XVIRTUALSCREEN = 76;
//	public static final int SM_YVIRTUALSCREEN = 77;
//	public static final int SM_CXVSCROLL = 0x2;
//	public static final int SM_CYBORDER = 0x6;
//	public static final int SM_CYCURSOR = 0xe;
//	public static final int SM_CYHSCROLL = 0x3;
//	public static final int SM_CYMENU = 0xf;
//	public static final int SM_CYSCREEN = 0x1;
//	public static final int SM_CYVSCROLL = 0x14;
//	public static final int SPI_GETWORKAREA = 0x30;
//	public static final int SPI_GETNONCLIENTMETRICS = 41;
//	public static final int SPI_GETWHEELSCROLLLINES = 104;
//	public static final int SRCAND = 0x8800c6;
//	public static final int SRCCOPY = 0xcc0020;
//	public static final int SRCINVERT = 0x660046;
//	public static final int SRCPAINT = 0xee0086;
//	public static final int SS_BITMAP = 0xe;
//	public static final int SS_CENTER = 0x1;
//	public static final int SS_CENTERIMAGE = 0x200;
//	public static final int SS_ICON = 0x3;
//	public static final int SS_LEFT = 0x0;
//	public static final int SS_LEFTNOWORDWRAP = 0xc;
//	public static final int SS_NOTIFY = 0x100;
//	public static final int SS_OWNERDRAW = 0xd;
//	public static final int SS_REALSIZEIMAGE = 0x800;
//	public static final int SS_RIGHT = 0x2;
//	public static final int STANDARD_RIGHTS_READ = 0x20000;
//	public static final int STD_COPY = 0x1;
//	public static final int STD_CUT = 0x0;
//	public static final int STD_FILENEW = 0x6;
//	public static final int STD_FILEOPEN = 0x7;
//	public static final int STD_FILESAVE = 0x8;
//	public static final int STD_PASTE = 0x2;
//	public static final int STM_SETIMAGE = 0x172;
	public static final int SWP_DRAWFRAME = 0x20;
	public static final int SWP_NOACTIVATE = 0x10;
//	public static final int SWP_NOCOPYBITS = 0x100;
//	public static final int SWP_NOMOVE = 0x2;
//	public static final int SWP_NOREDRAW = 0x8;
	public static final int SWP_NOSIZE = 0x1;
	public static final int SWP_NOZORDER = 0x4;
//	public static final int SW_ERASE = 0x4;
	public static final int SW_HIDE = 0x0;
//	public static final int SW_INVALIDATE = 0x2;
//	public static final int SW_PARENTOPENING = 0x3;
//	public static final int SW_RESTORE = OS.IsWinCE ? 0xd : 0x9;
//	public static final int SW_SCROLLCHILDREN = 0x1;
	public static final int SW_SHOW = 0x5;
//	public static final int SW_SHOWMAXIMIZED = OS.IsWinCE ? 0xb : 0x3;
//	public static final int SW_SHOWMINNOACTIVE = 0x7;
//	public static final int SW_SHOWNA = 0x8;
//	public static final int SW_SHOWNOACTIVATE = 0x4;
//	public static final int SYNCHRONIZE = 0x100000;
//	public static final int SYSTEM_FONT = 0xd;
//	public static final int S_OK = 0x0;
//	public static final int TBIF_COMMAND = 0x20;
//	public static final int TBIF_STATE = 0x4;
//	public static final int TBIF_IMAGE = 0x1;
//	public static final int TBIF_LPARAM = 0x10;
//	public static final int TBIF_SIZE = 0x40;
//	public static final int TBIF_STYLE = 0x8;
//	public static final int TBIF_TEXT = 0x2;
//	public static final int TBM_GETLINESIZE = 0x418;
//	public static final int TBM_GETPAGESIZE = 0x416;
//	public static final int TBM_GETPOS = 0x400;
//	public static final int TBM_GETRANGEMAX = 0x402;
//	public static final int TBM_GETRANGEMIN = 0x401;
//	public static final int TBM_GETTHUMBRECT = 0x419;
//	public static final int TBM_SETLINESIZE = 0x417;
//	public static final int TBM_SETPAGESIZE = 0x415;
//	public static final int TBM_SETPOS = 0x405;
//	public static final int TBM_SETRANGEMAX = 0x408;
//	public static final int TBM_SETRANGEMIN = 0x407;
//	public static final int TBM_SETTICFREQ = 0x414;
//	public static final int TBN_DROPDOWN = 0xfffffd3a;
//	public static final int TBN_FIRST = 0xfffffd44;
//	public static final int TBSTATE_CHECKED = 0x1;
//	public static final int TBSTYLE_DROPDOWN = 0x8;
//	public static final int TBSTATE_ENABLED = 0x4;
//	public static final int TBSTYLE_AUTOSIZE = 0x10;
//	public static final int TBSTYLE_EX_DRAWDDARROWS = 0x1;
//	public static final int TBSTYLE_FLAT = 0x800;
//	public static final int TBSTYLE_LIST = 0x1000;
//	public static final int TBSTYLE_TOOLTIPS = 0x100;
//	public static final int TBSTYLE_TRANSPARENT = 0x8000;
//	public static final int TBSTYLE_WRAPABLE = 0x200;
//	public static final int TBS_AUTOTICKS = 0x1;
//	public static final int TBS_BOTH = 0x8;
//	public static final int TBS_HORZ = 0x0;
//	public static final int TBS_VERT = 0x2;
//	public static final int TB_ADDSTRING = IsUnicode ? 0x44d : 0x41c;
//	public static final int TB_BUTTONCOUNT = 0x418;
//	public static final int TB_BUTTONSTRUCTSIZE = 0x41e;
//	public static final int TB_COMMANDTOINDEX = 0x419;
//	public static final int TB_DELETEBUTTON = 0x416;
//	public static final int TB_ENDTRACK = 0x8;
//	public static final int TB_GETBUTTON = 0x417;
//	public static final int TB_GETBUTTONINFO = IsUnicode ? 0x43f : 0x441;
//	public static final int TB_GETBUTTONSIZE = 0x43a;
//	public static final int TB_GETBUTTONTEXT = IsUnicode ? 0x44b : 0x42d;
//	public static final int TB_GETDISABLEDIMAGELIST = 0x437;
//	public static final int TB_GETHOTIMAGELIST = 0x435;
//	public static final int TB_GETHOTITEM = 0x0400 + 71;
//	public static final int TB_GETIMAGELIST = 0x431;
//	public static final int TB_GETITEMRECT = 0x41d;
//	public static final int TB_GETROWS = 0x428;
//	public static final int TB_GETSTATE = 0x412;
//	public static final int TB_GETTOOLTIPS = 0x423;
//	public static final int TB_INSERTBUTTON = IsUnicode ? 0x443 : 0x415;
//	public static final int TB_LOADIMAGES = 0x432;
//	public static final int TB_MAPACCELERATOR = 0x0400 + (IsUnicode ? 90 : 78);
//	public static final int TB_SETBITMAPSIZE = 0x420;
//	public static final int TB_SETBUTTONINFO = IsUnicode ? 0x440 : 0x442;
//	public static final int TB_SETBUTTONSIZE = 0x41f;
//	public static final int TB_SETDISABLEDIMAGELIST = 0x436;
//	public static final int TB_SETEXTENDEDSTYLE = 0x454;
//	public static final int TB_SETHOTIMAGELIST = 0x434;
//	public static final int TB_SETHOTITEM =  0x0400 + 72;
//	public static final int TB_SETIMAGELIST = 0x430;
//	public static final int TB_SETROWS = 0x427;
//	public static final int TB_SETSTATE = 0x411;
//	public static final int TCIF_IMAGE = 0x2;
//	public static final int TCIF_TEXT = 0x1;
//	public static final int TCI_SRCCHARSET = 0x1;
//	public static final int TCI_SRCCODEPAGE = 0x2;
//	public static final int TCM_ADJUSTRECT = 0x1328;
//	public static final int TCM_DELETEITEM = 0x1308;
//	public static final int TCM_GETCURSEL = 0x130b;
//	public static final int TCM_GETITEMCOUNT = 0x1304;
//	public static final int TCM_GETITEMRECT = 0x130a;
//	public static final int TCM_GETTOOLTIPS = 0x132d;
//	public static final int TCM_INSERTITEM = IsUnicode ? 0x133e : 0x1307;
//	public static final int TCM_SETCURSEL = 0x130c;
//	public static final int TCM_SETIMAGELIST = 0x1303;
//	public static final int TCM_SETITEM = IsUnicode ? 0x133d : 0x1306;
//	public static final int TCN_SELCHANGE = 0xfffffdd9;
//	public static final int TCN_SELCHANGING = 0xfffffdd8;
//	public static final int TCS_FOCUSNEVER = 0x8000;
//	public static final int TCS_MULTILINE = 0x200;
//	public static final int TCS_TABS = 0x0;
//	public static final int TCS_TOOLTIPS = 0x4000;
//	public static final int TME_HOVER = 0x1;
//	public static final int TME_LEAVE = 0x2;
//	public static final int TME_QUERY = 0x40000000;
//	public static final int TMPF_VECTOR = 0x2;
//	public static final String TOOLBARCLASSNAME = "ToolbarWindow32"; //$NON-NLS-1$
//	public static final String TOOLTIPS_CLASS = "tooltips_class32"; //$NON-NLS-1$
//	public static final int TPM_LEFTALIGN = 0x0;
//	public static final int TPM_LEFTBUTTON = 0x0;
//	public static final int TPM_RIGHTBUTTON = 0x2;
//	public static final String TRACKBAR_CLASS = "msctls_trackbar32"; //$NON-NLS-1$
//	public static final int TRANSPARENT = 0x1;
//	public static final int TTF_IDISHWND = 0x1;
//	public static final int TTF_SUBCLASS = 0x10;
//	public static final int TTM_ADDTOOL = IsUnicode ? 0x432 : 0x404;
//	public static final int TTM_DELTOOL = IsUnicode ? 0x433 : 0x405;
//	public static final int TTM_SETMAXTIPWIDTH = 0x418;
//	public static final int TTM_UPDATE = 0x41D;
//	public static final int TTN_FIRST = 0xfffffdf8;
//	public static final int TTN_GETDISPINFO = IsUnicode ? 0xfffffdee : 0xfffffdf8;
//	public static final int TTN_GETDISPINFOW = 0xfffffdee;
//	public static final int TTN_GETDISPINFOA = 0xfffffdf8;
//	public static final int TTN_POP = TTN_FIRST - 2;
//	public static final int TTN_SHOW = TTN_FIRST - 1;
//	public static final int TTS_ALWAYSTIP = 0x1;
//	public static final int TVE_COLLAPSE = 0x1;
//	public static final int TVE_EXPAND = 0x2;
//	public static final int TVGN_CARET = 0x9;
//	public static final int TVGN_CHILD = 0x4;
//	public static final int TVGN_FIRSTVISIBLE = 0x5;
//	public static final int TVGN_LASTVISIBLE = 0xa;
//	public static final int TVGN_NEXT = 0x1;
//	public static final int TVGN_NEXTVISIBLE = 0x6;
//	public static final int TVGN_PARENT = 0x3;
//	public static final int TVGN_PREVIOUSVISIBLE = 0x7;
//	public static final int TVGN_ROOT = 0x0;
//	public static final int TVHT_ONITEM = 0x46;
//	public static final int TVHT_ONITEMICON = 0x2;
//	public static final int TVHT_ONITEMLABEL = 0x4;
//	public static final int TVHT_ONITEMSTATEICON = 0x40;
//	public static final int TVIF_HANDLE = 0x10;
//	public static final int TVIF_IMAGE = 0x2;
//	public static final int TVIF_PARAM = 0x4;
//	public static final int TVIF_SELECTEDIMAGE = 0x20;
//	public static final int TVIF_STATE = 0x8;
//	public static final int TVIF_TEXT = 0x1;
//	public static final int TVIS_DROPHILITED = 0x8;
//	public static final int TVIS_EXPANDED = 0x20;
//	public static final int TVIS_SELECTED = 0x2;
//	public static final int TVIS_STATEIMAGEMASK = 0xf000;
//	public static final int TVI_FIRST = 0xffff0001;
//	public static final int TVI_LAST = 0xffff0002;
//	public static final int TVI_ROOT = 0xffff0000;
//	public static final int TVM_DELETEITEM = 0x1101;
//	public static final int TVM_ENSUREVISIBLE = 0x1114;
//	public static final int TVM_EXPAND = 0x1102;
//	public static final int TVM_GETBKCOLOR = 0x111f;
//	public static final int TVM_GETCOUNT = 0x1105;
//	public static final int TVM_GETIMAGELIST = 0x1108;
//	public static final int TVM_GETITEM = IsUnicode ? 0x113e : 0x110c;
//	public static final int TVM_GETITEMHEIGHT = 0x111c;
//	public static final int TVM_GETITEMRECT = 0x1104;
//	public static final int TVM_GETNEXTITEM = 0x110a;
//	public static final int TVM_GETTEXTCOLOR = 0x1120;
//	public static final int TVM_GETTOOLTIPS = OS.TV_FIRST + 25;
//	public static final int TVM_GETVISIBLECOUNT = OS.TV_FIRST + 16;
//	public static final int TVM_HITTEST = 0x1111;
//	public static final int TVM_INSERTITEM = IsUnicode ? 0x1132 : 0x1100;
//	public static final int TVM_SELECTITEM = 0x110b;
//	public static final int TVM_SETBKCOLOR = 0x111d;
//	public static final int TVM_SETIMAGELIST = 0x1109;
//	public static final int TVM_SETINSERTMARK = 0x111a;
//	public static final int TVM_SETITEM = IsUnicode ? 0x113f : 0x110d;
//	public static final int TVM_SETTEXTCOLOR = 0x111e;
//	public static final int TVN_BEGINDRAG = IsUnicode ? 0xfffffe38 : 0xfffffe69;
//	public static final int TVN_BEGINDRAGW = 0xfffffe38;
//	public static final int TVN_BEGINDRAGA = 0xfffffe69;
//	public static final int TVN_BEGINRDRAG = IsUnicode ? 0xfffffe37 : 0xfffffe68;
//	public static final int TVN_BEGINRDRAGW = 0xfffffe37;
//	public static final int TVN_BEGINRDRAGA = 0xfffffe68;
//	public static final int TVN_FIRST = 0xfffffe70;
//	public static final int TVN_ITEMEXPANDING = IsUnicode ? 0xfffffe3a : 0xfffffe6b;
//	public static final int TVN_ITEMEXPANDINGW = 0xfffffe3a;
//	public static final int TVN_ITEMEXPANDINGA = 0xfffffe6b;
//	public static final int TVN_SELCHANGED = IsUnicode ? 0xfffffe3d : 0xfffffe6e;
//	public static final int TVN_SELCHANGEDW = 0xfffffe3d;
//	public static final int TVN_SELCHANGEDA = 0xfffffe6e;
//	public static final int TVN_SELCHANGING = IsUnicode ? 0xfffffe3e : 0xfffffe6f;
//	public static final int TVN_SELCHANGINGW = 0xfffffe3e;
//	public static final int TVN_SELCHANGINGA = 0xfffffe6f;
//	public static final int TVSIL_NORMAL = 0x0;
//	public static final int TVSIL_STATE = 0x2;
//	public static final int TVS_DISABLEDRAGDROP = 0x10;
//	public static final int TVS_FULLROWSELECT = 0x1000;
//	public static final int TVS_HASBUTTONS = 0x1;
//	public static final int TVS_HASLINES = 0x2;
//	public static final int TVS_LINESATROOT = 0x4;
//	public static final int TVS_NOTOOLTIPS = 0x80;
//	public static final int TVS_SHOWSELALWAYS = 0x20;
//	public static final int TV_FIRST = 0x1100;
//	public static final int UIS_INITIALIZE = 3;
//	public static final int VERTRES = 0xa;
	public static final int VK_BACK = 0x8;
//	public static final int VK_CAPITAL = 0x14;
//	public static final int VK_CONTROL = 0x11;
//	public static final int VK_DECIMAL = 0x6E;
//	public static final int VK_DELETE = 0x2e;
//	public static final int VK_DIVIDE = 0x6f;
	public static final int VK_DOWN = 0x28;
//	public static final int VK_END = 0x23;
	public static final int VK_ESCAPE = 0x1b;
	public static final int VK_TBACK = VK_ESCAPE;
//	public static final int VK_F1 = 0x70;
//	public static final int VK_F10 = 0x79;
//	public static final int VK_F11 = 0x7a;
//	public static final int VK_F12 = 0x7b;
//	public static final int VK_F2 = 0x71;
//	public static final int VK_F3 = 0x72;
//	public static final int VK_F4 = 0x73;
//	public static final int VK_F5 = 0x74;
//	public static final int VK_F6 = 0x75;
//	public static final int VK_F7 = 0x76;
	public static final int VK_F8 = 0x77;
	public static final int VK_F9 = 0x78;
//	public static final int VK_HOME = 0x24;
//	public static final int VK_INSERT = 0x2d;
//	public static final int VK_LBUTTON = 0x1;
	public static final int VK_LEFT = 0x25;
//	public static final int VK_MBUTTON = 0x4;
//	public static final int VK_MENU = 0x12;
//	public static final int VK_MULTIPLY = 0x6A;
//	public static final int VK_NEXT = 0x22;
//	public static final int VK_NUMLOCK = 0x90;
//	public static final int VK_NUMPAD0 = 0x60;
//	public static final int VK_NUMPAD1 = 0x61;
//	public static final int VK_NUMPAD2 = 0x62;
//	public static final int VK_NUMPAD3 = 0x63;
//	public static final int VK_NUMPAD4 = 0x64;
//	public static final int VK_NUMPAD5 = 0x65;
//	public static final int VK_NUMPAD6 = 0x66;
//	public static final int VK_NUMPAD7 = 0x67;
//	public static final int VK_NUMPAD8 = 0x68;
//	public static final int VK_NUMPAD9 = 0x69;
//	public static final int VK_PRIOR = 0x21;
//	public static final int VK_RBUTTON = 0x2;
	public static final int VK_RETURN = 0xd;
	public static final int VK_RIGHT = 0x27;
//	public static final int VK_SCROLL = 0x91;
//	public static final int VK_SEPARATOR = 0x6C;
//	public static final int VK_SHIFT = 0x10;
//	public static final int VK_SPACE = 0x20;
//	public static final int VK_SUBTRACT = 0x6D;
//	public static final int VK_TAB = 0x9;
	public static final int VK_UP = 0x26;
//	public static final int VK_ADD = 0x6B;
//	public static final int VK_APP1 = 0xc1;
//	public static final int VK_APP2 = 0xc2;
//	public static final int VK_APP3 = 0xc3;
//	public static final int VK_APP4 = 0xc4;
//	public static final int VK_APP5 = 0xc5;
//	public static final int VK_APP6 = 0xc6;
	public static final int VK_ROCKER = 0x84;
	public static final int VK_DPAD = 0x85;
	public static final int VK_ACTION = 0x86;
//	public static final String WC_LISTVIEW = "SysListView32"; //$NON-NLS-1$
//	public static final String WC_TABCONTROL = "SysTabControl32"; //$NON-NLS-1$
//	public static final String WC_TREEVIEW = "SysTreeView32"; //$NON-NLS-1$
//	public static final int WH_GETMESSAGE = 0x3;
//	public static final int WH_MSGFILTER = 0xFFFFFFFF;
//	public static final int WHEEL_DELTA = 120;
	public static final int WM_ACTIVATE = 0x6;
//	public static final int WM_APP = 0x8000;
//	public static final int WM_CANCELMODE = 0x1f;
//	public static final int WM_CHANGEUISTATE = 0x0127;
	public static final int WM_CHAR = 0x102;
//	public static final int WM_CLEAR = 0x303;
	public static final int WM_CLOSE = 0x10;
	public static final int WM_COMMAND = 0x111;
//	public static final int WM_CONTEXTMENU = 0x7b;
//	public static final int WM_COPY = 0x301;
//	public static final int WM_CTLCOLORBTN = 0x135;
//	public static final int WM_CTLCOLORDLG = 0x136;
//	public static final int WM_CTLCOLOREDIT = 0x133;
//	public static final int WM_CTLCOLORLISTBOX = 0x134;
//	public static final int WM_CTLCOLORMSGBOX = 0x132;
//	public static final int WM_CTLCOLORSCROLLBAR = 0x137;
//	public static final int WM_CTLCOLORSTATIC = 0x138;
//	public static final int WM_CUT = 0x300;
//	public static final int WM_DESTROY = 0x2;
//	public static final int WM_DRAWITEM = 0x2b;
//	public static final int WM_ENDSESSION = 0x16;
//	public static final int WM_ERASEBKGND = 0x14;
//	public static final int WM_GETDLGCODE = 0x87;
//	public static final int WM_GETFONT = 0x31;
////	public static final int WM_GETICON = 0x7f;
//	public static final int WM_GETOBJECT = 0x003D;
//	public static final int WM_HELP = 0x53;
	public static final int WM_HOTKEY = 0x0312;
//	public static final int WM_HSCROLL = 0x114;
//	public static final int WM_IME_CHAR = 0x286;
//	public static final int WM_IME_COMPOSITION = 0x10f;
//	public static final int WM_INITDIALOG = 0x110;
//	public static final int WM_INITMENUPOPUP = 0x117;
	public static final int WM_KEYDOWN = 0x100;
//	public static final int WM_KEYFIRST = 0x100;
//	public static final int WM_KEYLAST = 0x108;
	public static final int WM_KEYUP = 0x101;
//	public static final int WM_KILLFOCUS = 0x8;
//	public static final int WM_LBUTTONDBLCLK = 0x203;
	public static final int WM_LBUTTONDOWN = 0x201;
	public static final int WM_LBUTTONUP = 0x202;
//	public static final int WM_MBUTTONDBLCLK = 0x209;
//	public static final int WM_MBUTTONDOWN = 0x207;
//	public static final int WM_MBUTTONUP = 0x208;
//	public static final int WM_MEASUREITEM = 0x2c;
//	public static final int WM_MENUCHAR = 0x120;
//	public static final int WM_MENUSELECT = 0x11f;
//	public static final int WM_MOUSEACTIVATE = 0x21;
//	public static final int WM_MOUSEFIRST = 0x200;
//	public static final int WM_MOUSEHOVER = 0x2a1;
//	public static final int WM_MOUSELEAVE = 0x2a3;
	public static final int WM_MOUSEMOVE = 0x200;
//	public static final int WM_MOUSEWHEEL = 0x20a;
//	public static final int WM_MOUSELAST = 0x20d;
//	public static final int WM_MOVE = 0x3;
//	public static final int WM_NCACTIVATE = 0x86;
//	public static final int WM_NCCALCSIZE = 0x83;
//	public static final int WM_NCHITTEST = 0x84;
//	public static final int WM_NOTIFY = 0x4e;
//	public static final int WM_NULL = 0x0;
	public static final int WM_PAINT = 0xf;
//	public static final int WM_PALETTECHANGED = 0x311;
//	public static final int WM_PASTE = 0x302;
//	public static final int WM_PRINTCLIENT = 0x0318;
//	public static final int WM_QUERYENDSESSION = 0x11;
//	public static final int WM_QUERYNEWPALETTE = 0x30f;
//	public static final int WM_QUERYOPEN = 0x13;
//	public static final int WM_RBUTTONDBLCLK = 0x206;
//	public static final int WM_RBUTTONDOWN = 0x204;
//	public static final int WM_RBUTTONUP = 0x205;
//	public static final int WM_SETCURSOR = 0x20;
	public static final int WM_SETFOCUS = 0x7;
//	public static final int WM_SETFONT = 0x30;
//	public static final int WM_SETICON = 0x80;
	public static final int WM_SETREDRAW = 0xb;
//	public static final int WM_SETTINGCHANGE = 0x1A;
//	public static final int WM_SHOWWINDOW = 0x18;
	public static final int WM_SIZE = 0x5;
//	public static final int WM_SYSCHAR = 0x106;
//	public static final int WM_SYSCOLORCHANGE = 0x15;
//	public static final int WM_SYSCOMMAND = 0x112;
//	public static final int WM_SYSKEYDOWN = 0x104;
//	public static final int WM_SYSKEYUP = 0x105;
//	public static final int WM_TIMER = 0x113;
//	public static final int WM_UNDO = 0x304;
	public static final int WM_USER = 0x400;
	public static final int WM_VSCROLL = 0x115;
//	public static final int WM_WINDOWPOSCHANGING = 0x46;
	public static final int WS_BORDER = 0x800000;
	public static final int WS_CAPTION = 0xc00000;
	public static final int WS_CHILD = 0x40000000;
	public static final int WS_CLIPCHILDREN = 0x2000000;
	public static final int WS_CLIPSIBLINGS = 0x4000000;
//	public static final int WS_EX_CAPTIONOKBTN = 0x80000000;
//	public static final int WS_EX_CLIENTEDGE = 0x200;
//	public static final int WS_EX_DLGMODALFRAME = 0x1;
//	public static final int WS_EX_STATICEDGE = 0x20000;
//	public static final int WS_EX_TOOLWINDOW = 0x80;
//	public static final int WS_EX_TOPMOST = 0x8;
//	public static final int WS_EX_TRANSPARENT = 0x20;
	public static final int WS_HSCROLL = 0x100000;
//	public static final int WS_MAXIMIZEBOX = OS.IsWinCE ? 0x20000 : 0x10000;
//	public static final int WS_MINIMIZEBOX = OS.IsWinCE ? 0x10000 : 0x20000;
//	public static final int WS_OVERLAPPED = OS.IsWinCE ? WS_BORDER | WS_CAPTION : 0x0;
//	public static final int WS_OVERLAPPEDWINDOW = 0xcf0000;
	public static final int WS_POPUP = 0x80000000;
	public static final int WS_SYSMENU = 0x80000;
//	public static final int WS_TABSTOP = 0x10000;
	public static final int WS_THICKFRAME = 0x40000;
	public static final int WS_VISIBLE = 0x10000000;
	public static final int WS_VSCROLL = 0x200000;

	public static final int WA_INACTIVE     = 0;
	public static final int WA_ACTIVE       = 1;
	public static final int WA_CLICKACTIVE  = 2;

	public static final int EIM_SPELL = 0;
	public static final int EIM_NUMBERS = 2;
}
