package com.ibm.ive.midp;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

import java.util.*;

import javax.microedition.midlet.*;

import com.ibm.ive.midp.util.*;
import com.ibm.oti.security.midp.*;

public class PushRegistryAlarmMIDlet extends MIDlet {

	static Hashtable gAlarmMIDlets = new Hashtable();
	static Timer gTimer;
	static MIDlet gInstance;

	public static long registerAlarm(final String midlet, long time) throws SecurityException, ClassNotFoundException {
		if (PermissionManager.getManager() != null) PermissionManager.getManager().checkPermission("javax.microedition.io.PushRegistry");

		if (midlet == null) throw new ClassNotFoundException();

		final int midletIndex;

		for (int i = 1; true; i++) {
			String entry = (String) MIDletManager.gProperties.get("MIDlet-" + i);
			if (entry == null) throw new ClassNotFoundException();

			int commaIndex = entry.lastIndexOf(',');
			if (commaIndex == -1) throw new ClassNotFoundException();
			String midletName = entry.substring(commaIndex+1, entry.length()).trim();
			if (midlet.equals(midletName)) {
				midletIndex = i;
				break;
			}
		}

		Class.forName(midlet); // throw ClassNotFoundException() if the class doesn't actually exist in the suite

		long previousTime = 0L;

		synchronized (gAlarmMIDlets) {
			Task prevTask = (Task) gAlarmMIDlets.get(midlet);
			if (prevTask != null) {
				previousTime = prevTask.fTime;
				prevTask.fTask.cancel(); // cancel previously scheduled task to run this MIDlet
			}

			TimerTask task = new TimerTask() {
				public void run() {
					MIDletManager.gAppManager.launch(midletIndex-1); // this is launched in a separate thread

					synchronized (gAlarmMIDlets) {
						gAlarmMIDlets.remove(midlet);
						if (gAlarmMIDlets.isEmpty()) {
							// cancel timer when there are no more alarms so the VM can quit if it needs to
							gInstance.notifyDestroyed();
							gInstance = null;
							gTimer.cancel();
							gTimer = null;
						}
					}
				}
			};
			gAlarmMIDlets.put(midlet, new Task(task, time));

			if (gInstance == null) {
				gInstance = createInstance();

				gTimer = new Timer();

				// start the Dummy MIDlet instance. This keeps the event loop alive as long as there are alarms waiting to run
				MIDletManager.gAppManager.launch(gInstance); // this is launched in a separate thread
			}

			gTimer.schedule(task, new Date(time));
		}

		return previousTime;
	}

	static MIDlet createInstance() {
		MIDletManager.gAppManager.allowInstantiation();
		MIDlet instance = new PushRegistryAlarmMIDlet();
		IMIDletAccessor accessor = MIDletManager.getAccessor(instance);
		String[] midletNames = MIDletManager.getMIDletNames();
		accessor.setMidletIndex(midletNames.length+1); // midletNames.length is used by MIDletSuite

		return instance;
	}

	static class Task {
		TimerTask fTask;
		long fTime;

		public Task(TimerTask task, long time) {
			fTask = task;
			fTime = time;
		}
	}

	protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
	}
	protected void pauseApp() {
	}
	protected void startApp() throws MIDletStateChangeException {
	}
}
