package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.MidpMsg;
import com.ibm.ive.midp.util.ProgramLauncher;

public class Autotester {

	LaunchConfiguration fConfiguartion;
	String fDebugArgs;

	public Autotester(LaunchConfiguration configuration, String debugArgs) {
		super();
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		fConfiguartion = configuration;
		fDebugArgs = debugArgs;
	}

	public void runTests(String url) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		while (true) {
			ConsoleBasedInstallListener listener = new ConsoleBasedInstallListener(true);

			InstallProcess process = new InstallProcess(url, MidpConstants.UPDATE_ANY, listener, false);
			process.run();
			MidletEntry installedMidlet = process.getInstalledMidlet();
			if (installedMidlet != null) {
				int result = ProgramLauncher.launchProgram(fConfiguartion.getProgramName(), fConfiguartion.getProgramArguments(installedMidlet, fDebugArgs), null, true);
				if (result == 0) {
					System.out.println(MidpMsg.getString("Autotester.runTests.error.midlet_failed_to_launch")); //$NON-NLS-1$
					return;
				}

				try {
					MidletStorage.delete(installedMidlet);
				} catch (AmsException e) {
					System.err.println(MidpMsg.getString("Autotester.runTests.error.error_removing_midlet")); //$NON-NLS-1$
					e.printStackTrace();
				}
			} else {
				AmsException e = process.getInstallFailure();
				switch (e.getStatus()) {
					case MidpConstants.RET_GATEWAY_BUSY:
						System.out.println(MidpMsg.getString("Autotester.runTests.error.server_busy")); //$NON-NLS-1$
						try {
							Thread.sleep(100);
						} catch (InterruptedException e1) {
						}
						break;
					default:
						System.out.println(MidpMsg.getString("Autotester.runTests.error.error_downloading_midlet")); //$NON-NLS-1$
						e.printStackTrace();
						return;
				}
			}
		}
	}
}
