package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import javax.microedition.lcdui.*;

import com.ibm.ive.midp.*;
import com.ibm.ive.midp.ams.ui.*;
import com.ibm.ive.midp.util.*;

public class ConsoleBasedInstallListener implements IInstallProcessListener {

	boolean fForce;

	public ConsoleBasedInstallListener(boolean force) {
		fForce = force;
	}

	void error(String error) {
		System.err.println(MidpMsg.getString("UEIHandler.error.error", error)); //$NON-NLS-1$
	}

	public void installFailed(AmsException reason) {
		error("\n" + MidpMsg.getString("UEIHandler.installFailed.failed", reason.getMessage())); //$NON-NLS-1$
	}

	public void installSucceeded(MidletEntry newMidlet, boolean isAnUpdate, boolean platformInstallProcess) {
		System.out.println(MidpMsg.getString("UEIHandler.installSucceded.success")); //$NON-NLS-1$
	}

	public boolean isCancelled() {
		return false;
	}

	public boolean isOkToInstallFromUntrustedSource(MidletEntry midlet) {
		return true;
	}

	public boolean isOkToUpdateFile(MidletEntry midlet, int code) {
		return fForce;
	}

	public boolean isOkToInstallFile(MidletEntry midlet) {
		return true;
	}

	public boolean isOkToRenameFile(MidletEntry midlet) {
		return false;
	}

	public boolean isOkToRetainRMS(String midlet) {
		return false;
	}

	public boolean isOkToUpdateDifferentPrincipal(String midlet) {
		return false;
	}

	public String getNewFileName(MidletEntry midlet) {
		return null;
	}

	public void notifyDownloadProgress(int bytesDownloaded, int totalSizeInBytes) {
		if (bytesDownloaded == 0) {
			System.out.println(MidpMsg.getString("UEIHandler.postBytesDownloaded.downloading")); //$NON-NLS-1$
		} else {
			System.out.print("."); //$NON-NLS-1$
		}
	}

	public void notifyDownloadFinished(int totalSizeInBytes) {
		System.out.println();
		System.out.println(MidpMsg.getString("UEIHandler.postBytesDownloaded.downloadingFinished")); //$NON-NLS-1$
	}

	public long getAvailableStorageSpace() {
		return FileStorage.getAvailableStorageSpace();
	}

	public String[] getUserNameAndPassword(String realm) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		NamePasswordPrompt prompt = new NamePasswordPrompt(realm);
		return prompt.openPrompt(Display.getDisplay(AmsMidlet.amsMidlet));
	}

}
