package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import java.io.*;
import java.util.*;
import javax.microedition.rms.*;
import com.ibm.ive.midp.*;
import com.ibm.oti.midlet.help.*;
import com.ibm.ive.midp.ams.ui.AmsMidlet;
import com.ibm.ive.midp.util.*;

public class MidletStorage implements MidpConstants {

	static final String RMS_NAME = "ams.midlet.catalog"; //$NON-NLS-1$
	static RecordStore gRecordStore;
	static FastVector gMidlets = new FastVector();
	public static Object gLock = new Object();

	static {
		loadSavedState();
	}

	public static MidletEntry get(String name, String vendor) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		int entries = size();
		for (int i = 0; i < entries; i++) {
			MidletEntry entry = get(i);
			if (name.equals(entry.getName()) && vendor.equals(entry.getVendor())) {
				return entry;
			}
		}
		return null;
	}

	public static String getNextRecordId() {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		String recordID = null;
		try {
			gRecordStore = RecordStore.openRecordStore(RMS_NAME, true);
			recordID = new Integer(gRecordStore.getNextRecordID()).toString();
		} catch (RecordStoreNotOpenException rsno) {
			rsno.printStackTrace();
		} catch (RecordStoreException rse) {
			rse.printStackTrace();
		} finally {
			if (gRecordStore != null) {
				try {
					gRecordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
		return recordID;
	}

	public static void add(MidletEntry newEntry) throws AmsException {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		if (newEntry.updatedMidlet == null) {
			gMidlets.addElement(newEntry);
		} else {
			int lastIndex = gMidlets.indexOf(newEntry.updatedMidlet);
			if (lastIndex == -1) {
				gMidlets.addElement(newEntry);
			} else {
				MidletEntry oldEntry = get(lastIndex);
				newEntry.setRecordID(oldEntry.getRecordID());
				gMidlets.removeElementAt(lastIndex);
				if (!throwAwayMidlet(newEntry.updatedMidlet)) {
					String jarFile = newEntry.updatedMidlet.getJarFile();
					String jadFile = newEntry.updatedMidlet.getJadFile();
					if (jarFile != null) ResourceDisposer.addResource(jarFile);
					if (jadFile != null) ResourceDisposer.addResource(jadFile);
				}
				gMidlets.insertElementAt(newEntry, lastIndex);
			}
		}

		synchronized (gLock) {
			try {
				gRecordStore = RecordStore.openRecordStore(RMS_NAME, true);
				newEntry.writeToRecordStore(gRecordStore);
			} catch (RecordStoreException e) {
				e.printStackTrace();
			} finally {
				if (gRecordStore != null) {
					try {
						gRecordStore.closeRecordStore();
					} catch (Exception e){
						e.printStackTrace();
					}
				}
			}
		}
	}

	public static boolean delete(MidletEntry targetMidlet) throws AmsException {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		if (gMidlets == null || targetMidlet == null) throw new NullPointerException();

		int midletIndex = gMidlets.indexOf(targetMidlet);
		if (midletIndex == -1) throw new AmsException(RET_INTERNAL_ERROR, MidpMsg.getString("MidletCatalog.uninstallMidlet.error.midlet_not_found")); //$NON-NLS-1$

		// Signal back to the delete notify server before deleting the manifest and
		// jad for good
		Hashtable props = targetMidlet.getProperties();
		String deleteNotifyURL = (String)props.get("MIDlet-Delete-Notify"); //$NON-NLS-1$
		if (deleteNotifyURL != null) {
			try {
				MessageDispatch.reportStatus(MidpConstants.STATUS_DELETE_NOTIFICATION, deleteNotifyURL);
				PendingStatusReporter.sendPendingStatusReports();
			} catch (IOException e) {
				PendingStatusReporter.addNotification(MidpConstants.STATUS_DELETE_NOTIFICATION, deleteNotifyURL);
				e.printStackTrace();
			}
		}

		// Delete the JAR and JAD
		if (!throwAwayMidlet(targetMidlet)) return false;
		MidletLoader.init(targetMidlet.getName(), targetMidlet.getVendor());
		MidletSuiteId suiteId = MidletLoader.getMidletSuiteId();
		MidletLoader.deleteMidletSuiteRMS(suiteId);
		MidletLoader.deleteMidletSuiteMetadata(suiteId);
		MidletLoader.init(AmsMidlet.amsMidlet.getAppProperty("MIDlet-Name"), AmsMidlet.amsMidlet.getAppProperty("MIDlet-Vendor"));
		deleteRecord(targetMidlet);
		gMidlets.removeElementAt(midletIndex);

		return true;
	}

	static boolean throwAwayMidlet(MidletEntry entry) {
		String jarFile = entry.getJarFile();
		if (jarFile == null || !FileStorage.delete(jarFile)) return false;

		//now the jar has been deleted successfully. so return true irrespective of the outcome
		//of jad deletion as, since the jar is gone, the rms data should also be deleted
		String jadFile = entry.getJadFile();
		if (jadFile != null) FileStorage.delete(jadFile);

		return true;
	}

	public static int size() {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		return gMidlets.size();
	}

	public static MidletEntry get(int index) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		if (index < 0 || index > size() - 1) return null;
		return (MidletEntry) gMidlets.elementAt(index);
	}

	static void deleteRecord(MidletEntry entry){
		int recID = Integer.parseInt(entry.getRecordID());
		try {
			gRecordStore = RecordStore.openRecordStore(RMS_NAME, true);
			gRecordStore.deleteRecord(recID);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (gRecordStore != null) {
				try {
					gRecordStore.closeRecordStore();
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		}
	}

	public static MidletEntry get(String midletName) {
		try {
			int index = Integer.parseInt(midletName);
			return MidletStorage.get(index - 1);
		} catch (NumberFormatException exp1) {
			// The application passed in was not a number so
			// we will look for the midlet by name
			int length = MidletStorage.size();
			for (int i = 0; i < length; i++) {
				MidletEntry entry = MidletStorage.get(i);
				String storageName = entry.getStorageName();
				if (storageName.equals(midletName)) return entry;
			}
			return null;
		}
	}

	static void loadSavedState() {
		synchronized (gLock) {

			try {
				gRecordStore = RecordStore.openRecordStore(RMS_NAME, true);
				if (gRecordStore.getNumRecords() > 0) {
					RecordEnumeration re = gRecordStore.enumerateRecords(null, null, false);
					while (re.hasNextElement()) {
						Hashtable prop = JadParser.parse(new ByteArrayInputStream(gRecordStore.getRecord(re.nextRecordId())));
						MidletEntry entry = new MidletEntry(prop);
						gMidlets.addElement(entry);
					}
				}
			} catch (RecordStoreException r){
				r.printStackTrace();
			} finally {
				if (gRecordStore != null) {
					try {
						gRecordStore.closeRecordStore();
					} catch (Exception e){
						e.printStackTrace();
					}
				}
			}
		}
	}

	public static void deleteAll() {
		synchronized (gLock) {
			int size = size();
			for (int i = size - 1; i >= 0; i--) {
				try {
					MidletEntry entry = get(i);
					if (entry != null) delete(entry);
				} catch (AmsException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * Deletes all the RMS data for a given midlet.
	 *
	 * @param entry the midlet whose record stores should be deleted
	 */

}
