package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

public interface MidpConstants {

	//----  STATUS CODES ----------------------------------
	public static final int RET_ILLEGAL_ARGUMENT = 0x00000001;
	public static final int RET_MIDLET_NOT_FOUND = 0x00000002;
	public static final int RET_OUT_OF_MEMORY = 0x00000003;
	public static final int RET_FILE_OPEN_FAILURE = 0x00000004;
	public static final int RET_HOST_NOT_FOUND = 0x00000005;
	public static final int RET_INVALID_SCHEME = 0x00000006;
	public static final int RET_MALFORMED_URL = 0x00000007;
	public static final int RET_INVALID_DESCRIPTOR_FILE = 0x00000008;
	public static final int RET_CONNECTION_FAILED = 0x00000009;
	public static final int RET_COMM_FAILURE = 0x0000000A;
	public static final int RET_GATEWAY_BUSY = 0x0000000B;
	public static final int RET_IO_ERROR = 0x0000000C;
	public static final int RET_OPERATION_CANCELLED = 0x0000000D;
	public static final int RET_UNKOWN_AUTHENTICATION_MODE = 0x0000000E;
	public static final int RET_SIGNATURE_PROBLEM = 0x0000000F;
	public static final int RET_JAR_SIZE_MISMATCH = 0x00000010;
	public static final int RET_CONFIG_PROFILE_PROBLEM = 0x00000011;
	public static final int RET_INVALID_JAR_FILE = 0x00000012;
	public static final int RET_ATTRIBUTE_MISMATCH = 0x00000013;
	public static final int RET_INVALID_PERMISSION = 0x00000014;

	// Add new Errors Here

	public static final int RET_INTERNAL_ERROR = 0x000000FF;

	public static final int PROMPT_SAME_VERSION_EXISTS = 0x00001001;
	public static final int PROMPT_EARLIER_VERSION_EXISTS = 0x00001002;
	public static final int PROMPT_LATER_VERSION_EXISTS = 0x00001004;
	public static final int PROMPT_DIFFERENT_LOCATION = 0x00010000;
	public static final int PROMPT_UNTRUSTED_MIDLET = 0x10000000;
	public static final int PROMPT_BEFORE_DOWNLOAD = 0x20000000;

	//----  INSTALL OPTIONS  -------------------------------
	public static final int INSTALL_MIDLET = 0x00000011;
	public static final int UPDATE_IF_LATER_VERSION = 0x00000012;
	public static final int UPDATE_IF_SAME_OR_LATER = 0x00000014;
	public static final int UPDATE_ANY = 0x00000018;
	public static final int DIFFERENT_LOCATION = 0x00000100;

	// Constants for the MIDlet attributes in either the Application Descriptor
	// or the Manifest
	public static final String KEY_INSTALL_NOTIFY 		= "MIDlet-Install-Notify"; //$NON-NLS-1$
	public static final String KEY_DELETE_NOTIFY		= "MIDlet-Delete-Notify"; //$NON-NLS-1$
	public static final String KEY_MIDLET_NAME 			= "MIDlet-Name"; //$NON-NLS-1$
	public static final String KEY_MIDLET_VENDOR 		= "MIDlet-Vendor"; //$NON-NLS-1$
	public static final String KEY_MIDLET_VERSION 		= "MIDlet-Version"; //$NON-NLS-1$
	public static final String KEY_MIDLET_DESCRIPTION 	= "MIDlet-Description"; //$NON-NLS-1$
	public static final String KEY_MIDLET_INFO_URL 		= "MIDlet-Info-URL"; //$NON-NLS-1$
	public static final String KEY_MIDLET_PROFILE 		= "MicroEdition-Profile"; //$NON-NLS-1$
	public static final String KEY_MIDLET_CONFIGURATION	= "MicroEdition-Configuration"; //$NON-NLS-1$
	public static final String KEY_MIDLET_PERMISSIONS	= "MIDlet-Permissions"; //$NON-NLS-1$
	public static final String KEY_MIDLET_PERMISSIONS_OPT = "MIDlet-Permissions-Opt"; //$NON-NLS-1$
	public static final String KEY_MIDLET_ICON		    = "MIDlet-Icon"; //$NON-NLS-1$
	public static final String KEY_MIDLET_JAR_URL		= "MIDlet-Jar-URL"; //$NON-NLS-1$
	public static final String KEY_MIDLET_JAR_SIZE		= "MIDlet-Jar-Size"; //$NON-NLS-1$
	public static final String KEY_MIDLET_DATA_SIZE		= "MIDlet-Data-Size"; //$NON-NLS-1$

	// Installation/Deletion status reports
	public static final int STATUS_SUCCESS                = 900;
	public static final int STATUS_INSUFFICIENT_MEMORY    = 901;
	public static final int STATUS_USER_CANCELLED         = 902;
	public static final int STATUS_LOSS_OF_SERVICE        = 903;
	public static final int STATUS_JAR_SIZE_MISMATCH      = 904;
	public static final int STATUS_ATTRIBUE_MISMATCH      = 905;
	public static final int STATUS_INVALID_DESCRIPTOR     = 906;
	public static final int STATUS_INVALID_JAR            = 907;
	public static final int STATUS_INCOMPATIBLE_PROFILE   = 908;
	public static final int STATUS_AUTHENTICATION_FAILURE = 909;
	public static final int STATUS_AUTHORIZATION_FAILURE  = 910;
	public static final int STATUS_PUSH_FAILURE           = 911;
	public static final int STATUS_DELETE_NOTIFICATION    = 912;
}
