package com.ibm.ive.midp.ams;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import javax.microedition.rms.*;

import com.ibm.ive.midp.util.*;

public class ResourceDisposer {

	static final String RMS_NAME = "ams.resource"; //$NON-NLS-1$
	static final int MAX_RETRIES = 5;

	public static void addResource(String resString){
		RecordStore recordStore = null;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			byte[] buf = new StringBuffer(resString).append("*1").toString().getBytes();
			recordStore.addRecord(buf, 0, buf.length);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				recordStore.closeRecordStore();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}

	static String getResourceString(String recordString) {
		return recordString.substring(0, recordString.indexOf('*'));
	}

	static int getRetries(String recordString) {
		return Integer.parseInt(recordString.substring(recordString.indexOf('*') + 1));
	}

	static void setRetries(RecordStore recordStore, int recordId, String recordString, int retries) {
		String newRecord = recordString.substring(0, recordString.indexOf('*') + 1) + retries;
		try {
			recordStore.setRecord(recordId, newRecord.getBytes(), 0, newRecord.length());
		} catch (RecordStoreException r) {
			r.printStackTrace();
		}
	}

	static String[][] getRecords(RecordStore recordStore, int length) {
		String[][] urls = new String[length][2];
		try {
			RecordEnumeration records = recordStore.enumerateRecords(null, null, false);

			while (records.hasNextElement()) {
				int rec = records.nextRecordId();
				urls[--length][0] = String.valueOf(rec);
				urls[length][1] = new String(recordStore.getRecord(rec));
			}
		} catch (RecordStoreException r) {
			r.printStackTrace();
		}
		return urls;
	}

	static void handleRetries(RecordStore recordStore, int recordId, String recordString) {
		int retries = getRetries(recordString);
		if (retries < MAX_RETRIES) {
			setRetries(recordStore, recordId, recordString, retries + 1);
		} else {
			try {
				recordStore.deleteRecord(recordId);
			} catch (RecordStoreException e) {
				e.printStackTrace();
			}
		}
	}

//	public static void clear() {
//		try {
//			RecordStore.deleteRecordStore(RMS_NAME);
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//	}

	public static void processResourcesAwaitingDeletion() {
		RecordStore recordStore = null;
		int length = 0;
		try {
			recordStore = RecordStore.openRecordStore(RMS_NAME, true);
			length = recordStore.getNumRecords();
			if (length == 0) return;

			final String[][] records = getRecords(recordStore, length);
			for (int i = 0; i < length; i++) {
				int recordId = Integer.parseInt(records[i][0]);
				try {
					String resource = getResourceString(records[i][1]);
					if (!FileStorage.delete(resource)) {
						handleRetries(recordStore, recordId, records[i][1]);
						break;
					}
					recordStore.deleteRecord(recordId);
				} catch (Exception e) {
					handleRetries(recordStore, recordId, records[i][1]);
					e.printStackTrace();
					break;
				}
			}
		} catch (Exception e1) {
			/* do nothing */
		} finally {
			try {
				recordStore.closeRecordStore();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
}
