package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.oti.connection.file.*;

public class AmsMidlet extends MIDlet {

	Displayable fCurrentDisplayable;
	public static MidletList fMidletList;
	public static MIDlet amsMidlet;
	static final String UEI_ARG_PREFIX = "uei.arg"; //$NON-NLS-1$
	String fVmOptions;

	public AmsMidlet() {
		super();
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		amsMidlet = this;
	}

	protected void destroyApp(boolean flag) throws MIDletStateChangeException {
	}

	protected void pauseApp() {
	}

	protected void startApp() throws MIDletStateChangeException {
		Display display = Display.getDisplay(this);
		if (display.getCurrent() == null) {
			String[] ueiArgs = collectUEIArguments();

			if (ueiArgs.length > 0) {
				// EUI arguments have been specified and we need to start the arguement
				// handling code
				UEIHandler handler = new UEIHandler(this, ueiArgs);
				Thread EUIThread = new Thread(handler);
				EUIThread.start();
			} else {
				display.setCurrent(getMidletList(display));
			}
		}

		PendingStatusReporter.sendPendingStatusReports(); // try to send any unsent status reports
	}

	/**
	 * Collects all the UEI arguments into an array.  This method will always
	 * return an array, and the array will be empty if no arguments are available.
	 *
	 * @return an array of all the UEI arguments
	 */
	static String[] collectUEIArguments() {
		FastVector args = new FastVector();
		int count = 1;
		boolean done = false;

		do {
			String nextArgument = System.getProperty(UEI_ARG_PREFIX + count);
			if (nextArgument == null) {
				done = true;
			} else {
				args.addElement(nextArgument);
				count++;
			}
		} while (!done);

		/*
		 * No UEI args were passed.
		 * Try to locate the browser temporary file.
		 */
		if (count == 1) {
			String tempName = "BrowserTempDownload"; //$NON-NLS-1$
			FileInputStream is = null;
			try {
				is = new FileInputStream(tempName);
				if (is!=null) {
					args.addElement("-Xjam:install=file:" + tempName); //$NON-NLS-1$
					args.addElement("-Xjam:showUI"); //$NON-NLS-1$
					is.close();
				}
			} catch(Exception e) {
			}
		}

		String[] result = new String[args.size()];
		args.copyInto(result);
		return result;
	}

	/**
	 * Returns the Displayable that should be used to display that currently
	 * installed midlets.
	 *
	 * @param repo the midlet repository to display
	 * @return the Displayable showing the installed midlets
	 */
	public static MidletList getMidletList(Display display) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		if (fMidletList == null) {
			fMidletList = new MidletList(display, amsMidlet);
		}
		return fMidletList;
	}

	static void startUpdateProcess(MidletEntry midletEntry, Display display) {
		// Setup the update process
		Displayable current = display.getCurrent();
		DisplayBasedInstallListener listener = new DisplayBasedInstallListener(current, current, display);

		// Default to updating the midlet from the location that the jad was downloaded from
		// but it is possible that the midlet suite was installed as a jar and the location
		// that it was installed from will be used.
		String updateURL = midletEntry.getJadURL();
		if (updateURL == null) {
			updateURL = midletEntry.getJarURL();
		}

		// This should not happen, but might as well be safe
		if (updateURL == null) {
			Alert alert = new Alert(MidpMsg.getString("MidletInfoPage.startUpdateProcess.error.title"), MidpMsg.getString("MidletInfoPage.startUpdateProcess.error.update_location_unknown"),null, AlertType.ERROR); //$NON-NLS-1$ //$NON-NLS-2$
			display.setCurrent(alert);
		} else {
			InstallProcess process = new InstallProcess(updateURL, MidpConstants.UPDATE_IF_LATER_VERSION, listener, false);
			listener.showProgressUI(MidpMsg.getString("MidletInfoPage.startUpdateProcess.message.updating_midlet", updateURL)); //$NON-NLS-1$

			// Run the install process in the seperate thread so that the ui is not blocked
			// and the user has the ability to press cancel
			Thread installThread = new Thread(process);
			installThread.start();
		}
	}
}
