package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import java.util.*;
import javax.microedition.lcdui.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.ive.midp.*;

class MidletInfoPage implements CommandListener {

	MidletEntry fMidletEntry;
	Displayable fPreviousDisplayable;
	Display fDisplay;

	public MidletInfoPage(MidletEntry entry) {
		fMidletEntry = entry;
	}

	Form buildForm() {
		Form form = new Form(MidpMsg.getString("MidletInfoPage.buildForm.title")); //$NON-NLS-1$
		addInfoItems(form);

		form.addCommand(CommandFactory.getCommand(CommandFactory.BACK_COMMAND));

//		fMIDletOptionsCommand = new Command(MidpMsg.getString("MidletInfoPage.buildForm.command.options"),Command.SCREEN,3); //$NON-NLS-1$
//		form.addCommand(fMIDletOptionsCommand);

		form.addCommand(CommandFactory.getCommand(CommandFactory.PERMISSION_COMMAND));
		form.setCommandListener(this);
		return form;
	}

	void addInfoItems(Form form) {
		String version = fMidletEntry.getVersion();
		Hashtable properties = fMidletEntry.getProperties();

		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.name"), fMidletEntry.getName())); //$NON-NLS-1$

		String description = (String)properties.get(MidpConstants.KEY_MIDLET_DESCRIPTION);
		if (description == null) description = MidpMsg.getString("MidletInfoPage.addInfoItems.no_description"); //$NON-NLS-1$
		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.description"), description)); //$NON-NLS-1$

		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.version"), version)); //$NON-NLS-1$

		String infoURL = (String)properties.get(MidpConstants.KEY_MIDLET_INFO_URL);
		if (infoURL == null) infoURL = MidpMsg.getString("MidletInfoPage.addInfoItems.no_info_url"); //$NON-NLS-1$
		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.info_url"), infoURL)); //$NON-NLS-1$

		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.vendor"), fMidletEntry.getVendor())); //$NON-NLS-1$

		String domain = fMidletEntry.getSecurityDomain();
		if (domain.equals("untrusted")) domain = MidpMsg.getString("UntrustedSecurityDomain"); //$NON-NLS-1$ //$NON-NLS-2$
		form.append(new StringItem(MidpMsg.getString("MidletInfoPage.addInfoItems.security_domain"), domain));		 //$NON-NLS-1$
	}

	public void show(Display display) {
		fDisplay = display;
		fPreviousDisplayable = fDisplay.getCurrent();
		fDisplay.setCurrent(buildForm());
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gBackCommand) {
			fDisplay.setCurrent(fPreviousDisplayable);
//		} else if (aCommand == fMIDletOptionsCommand) {
//			fDisplay.setCurrent(page = new MIDletOptionsPage(fMidletEntry,aDisplayable,fDisplay));
		} else if (aCommand == CommandFactory.gPermissionCommand) {
			fDisplay.setCurrent(new PermissionsList(fDisplay, aDisplayable, fMidletEntry));
		}
	}
}
