package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import javax.microedition.lcdui.*;

abstract class ModalPrompt {

	Object fLock;

	/**
	 * Un-blocks the showDialog method, allowing it to finish.
	 */
	protected void unlock() {
		synchronized (fLock) {
			fLock.notifyAll();
			fLock = null;
		}
	}

	/**
	 * Returns the displayable that the user will see when the prompt is shown.
	 *
	 * @return the displayble to shown to the user
	 */
	protected abstract Displayable getDisplayable();

	/**
	 * Shows the prompt on the specified display.
	 *
	 * @param display
	 * @return int
	 */
	protected void showDialog(Display display) {
		fLock = new Object();
		Displayable oldDisplayable = display.getCurrent();
		// Present the prompt to the user
		callHiddenSetCurrentImpl(display, getDisplayable());

		// wait for the prompt to go away before the method will finish
		if (fLock != null) {
			synchronized (fLock) {
				try {
					if (fLock != null) fLock.wait();
				} catch (InterruptedException e) {
				}
			}
		}

		/*
		 * if we are installing using ConsoleBasedInstallListener,
		 * oldDisplayable will be null. So setting MidletList as oldDisplayable
		 * PR 114577
		 */
		if (oldDisplayable == null) {
			AmsMidlet.getMidletList(display).rebuildPage();
			oldDisplayable = AmsMidlet.getMidletList(display);
		}

		/*
		 * return the user to the screen that they were
		 * previously looking at
		 */
		callHiddenSetCurrentImpl(display, oldDisplayable);
	}

	static native void callHiddenSetCurrentImpl(Display display, Displayable displayable);
}
