package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import java.util.*;
import javax.microedition.lcdui.*;
import com.ibm.ive.midp.*;
import com.ibm.ive.midp.ams.*;
import com.ibm.oti.security.midp.*;

class PermissionsList extends List implements CommandListener, IMIDletPermissions {

	MidletEntry fMidletEntry;
	Display fDisplay;
	Displayable fPreviousDisplayable;
	String[] fPermissionList;

	static final String LABEL_PREFIX = "label_"; //$NON-NLS-1$

	/**
	 * Create the permissions List
	 * @param display - device's display
	 * @param previous - displayable that will be redisplayed upon completion
	 * @param midlet - MidletEntry describing the midlet whose permissions are changing
	 */
	public PermissionsList(Display display, Displayable previous, MidletEntry midletEntry) {
		super(MidpMsg.getString("PermissionsList.constructor.title"), Choice.IMPLICIT); //$NON-NLS-1$

		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		fDisplay = display;
		fPreviousDisplayable = previous;
		fMidletEntry = midletEntry;

		buildPermList();

		addCommand(CommandFactory.getCommand(CommandFactory.BACK_COMMAND));
		addCommand(CommandFactory.getCommand(CommandFactory.SELECT_COMMAND));
		setSelectCommand(CommandFactory.gSelectCommand);
		setCommandListener(this);
	}

	void buildPermList() {
		String domainName = fMidletEntry.getSecurityDomain();
		Enumeration permissions = SecurityPolicy.getInstance().getProtectionDomain(domainName).getPermissionNames();
		FastVector permissionList = new FastVector();

		while (permissions.hasMoreElements()) {
			permissionList.addElement(permissions.nextElement());
		}

		fPermissionList = new String[permissionList.size()];
		permissionList.copyInto(fPermissionList);

		String[] permissionDisplayStrings = sortPermissionList();

		for (int i = 0; i < permissionDisplayStrings.length; i++) {
			append(permissionDisplayStrings[i], null);
		}
	}

	String[] sortPermissionList() {
		String[] displayStrings = new String[fPermissionList.length];
		for (int i = 0; i < displayStrings.length; i++) {
			displayStrings[i] = PermissionMsg.getString(LABEL_PREFIX + fPermissionList[i], fPermissionList[i]);
		}

		String indexString, indexDisplayString;
		int j = 0;

		/*
		 * Insertion sort. Permission Name and Permission String
		 * should be kept in sync.
		 */
		for (int i = 1; i < displayStrings.length; i++) {
			indexDisplayString = displayStrings[i];
			indexString = fPermissionList[i];
			j = i;
			while (j > 0 && displayStrings[j - 1].compareTo(indexDisplayString) > 0) {
				displayStrings[j] = displayStrings[j - 1];
				fPermissionList[j] = fPermissionList[j - 1];
				j--;
			}
			displayStrings[j] = indexDisplayString;
			fPermissionList[j] = indexString;
		}

		return displayStrings;
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gBackCommand) {
			fDisplay.setCurrent(fPreviousDisplayable);
		} else if (aCommand == CommandFactory.gSelectCommand) {
			PermissionsPage page = new PermissionsPage(fDisplay, aDisplayable, fMidletEntry, fPermissionList[getSelectedIndex()]);
			fDisplay.setCurrent(page);
		}
	}
}
