package com.ibm.ive.midp.ams.ui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import java.util.*;
import javax.microedition.lcdui.*;

class QuestionPrompt extends ModalPrompt implements CommandListener {

	Hashtable fReturnValues;
	Alert fAlert;
	int fReturnValue;

	public QuestionPrompt(String title, String message) {
		fAlert = new Alert(title,message, null, AlertType.CONFIRMATION);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		fReturnValue = ((Integer) fReturnValues.get(aCommand)).intValue();
		unlock();
	}

	/**
	 * Adds a new response to this Alert.
	 *
	 * @param responseText the text for the new response
	 * @param priority the priority of the response
	 * @param runnable the runnable to execute if the response it chosen
	 */
	public void addResponse(String responseText, int priority, int returnValue) {
		Command c = new Command(responseText, Command.SCREEN, priority);

		if (fReturnValues == null) {
			fReturnValues = new Hashtable();
			fAlert.setCommandListener(this);
		}

		fReturnValues.put(c, new Integer(returnValue));
		fAlert.addCommand(c);
	}

	protected Displayable getDisplayable() {
		return fAlert;
	}

	public int openPrompt(Display display) {
		showDialog(display);
		return fReturnValue;
	}
}
