package com.ibm.ive.midp.ams.ui;

import javax.microedition.lcdui.*;
import com.ibm.ive.midp.MidpMsg;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */
public class RenamePrompt extends ModalPrompt implements CommandListener {

	protected TextField fmidletName;
	protected boolean fCanceled;

	public RenamePrompt() {
	}

	protected Displayable getDisplayable() {
		Form form = new Form(MidpMsg.getString("reNamePrompt.getDisplayable.title"));  //$NON-NLS-1$
		form.append(MidpMsg.getString("reNamePrompt.getDisplayable.message"));  //$NON-NLS-1$
		fmidletName = new TextField(MidpMsg.getString("reNamePrompt.getDisplayable.newname"), "", 20, TextField.ANY);  //$NON-NLS-1$ //$NON-NLS-2$
		form.append(fmidletName);
		form.addCommand(CommandFactory.getCommand(CommandFactory.OK_COMMAND));
		form.addCommand(CommandFactory.getCommand(CommandFactory.CANCEL_COMMAND));
		form.setCommandListener(this);
		return form;
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (aCommand == CommandFactory.gCancelCommand) fCanceled = true;

		unlock();
	}

	String getName(Display display) {
		fCanceled = false;

		super.showDialog(display);
		if (fCanceled) return null;

		String name = fmidletName.getString();
		if (name.length() > 0) {
			return name;
		} else {
			return null;
		}
	}
}
