package com.ibm.ive.midp.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

public interface IFileDownloadListener {

	boolean isCancelled();

	public void notifyDownloadProgress(int bytesDownloaded, int totalSizeInBytes);
	public void notifyDownloadFinished(int totalSizeInBytes);

	/*
	 * Answer the size in bytes of storage space available for the downloaded file.
	 */
	public long getAvailableStorageSpace();

	/*
	 * It may be necessary to authenticate to an http server to complete the download.
	 * Answer the user name and password to use for authentication.
	 */
	public String[] getUserNameAndPassword(String realm);

}
