package com.ibm.microedition.media;

/*
 *
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.util.*;
import javax.microedition.media.control.*;
import com.ibm.ive.midp.*;

/**
 * Static Event Manager class for managing multiple players events.
 *
 */
public class MediaEventManager {

	static private BlockingQueue gEventQueue;
	static private Thread gEventThread;
	static private Vector gOpenPlayers;
	static private boolean activeplayers=false;
	static private Object lastEventInQueue;

	static {
		com.ibm.oti.vm.VM.addShutdownClass(new Runnable() {
			public void run() {
				cleanUp();
			}
		});
	}

	static public void registerPlayer(MediaPlayer player) {

		if (!activeplayers)
		{
			gEventQueue = new BlockingQueue();
			gOpenPlayers = new Vector();
			gEventThread = new Thread() {
				public void run() {
					runEventThread();
				}
			};
			gEventThread.start();
		}

		synchronized (gOpenPlayers) {
			gOpenPlayers.addElement(player);
			activeplayers = true;
		}
	}

	static public void unregisterPlayer(MediaPlayer player) {

		synchronized (gOpenPlayers) {
			gOpenPlayers.removeElement(player);
			if (gOpenPlayers.isEmpty()) {
				lastEventInQueue = new Object();
				gEventQueue.postObject(new Object[] {lastEventInQueue});
				activeplayers = false;
			}
		}
	}

	/* This is the final attempt to cleanup. Will be called
	 * when the Class is shutdown.
	 */
	static public synchronized void cleanUp() {
		for (int i = 0; i < gOpenPlayers.size(); i++) {
			MediaPlayer player = (MediaPlayer) gOpenPlayers.elementAt(i);
			if (null != player) player.close(true);
		}
		gOpenPlayers.removeAllElements();
	}

	static private void runEventThread() {
		do  {
			Object[] eventRecord = (Object[]) gEventQueue.getNextObject();
			if (null == eventRecord) continue;

			//wait for the last event in the queue
			if (eventRecord.length==1)
			{
				synchronized (lastEventInQueue) {
					eventRecord[0].notifyAll();
				}
			} else {
				MediaPlayer player = (MediaPlayer) eventRecord[0];
				String event = (String) eventRecord[1];
				Object eventData = eventRecord[2];
				if (null != player) player.fireEventHandlers(event, eventData);
			}
			Thread.yield();
		} while (activeplayers);
	}

	static private void postEvent(MediaPlayer mediaPlayer, String event, Object eventData) {
		synchronized (gEventQueue) {
			gEventQueue.postObject(new Object[] { mediaPlayer, event, eventData });
		}
	}

	static public void postEventNull(MediaPlayer mediaPlayer, String event) {
		postEvent(mediaPlayer, event, null);
	}

	static public void postEventString(MediaPlayer mediaPlayer, String event, String eventData) {
		postEvent(mediaPlayer, event, eventData);
	}

	static public void postEventLong(MediaPlayer mediaPlayer, String event, long eventData) {
		postEvent(mediaPlayer, event, new Long(eventData));
	}

	static public void postEventVolumeControl(MediaPlayer mediaPlayer, String event, VolumeControl volumeControl) {
		postEvent(mediaPlayer, event, volumeControl);
	}
}
