package com.ibm.microedition.media;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.util.*;
import com.ibm.microedition.media.typechecker.*;

/**
 *
 * This class represents a registry for a specific media
 * impementation. Register the followings:
 * - Supported types for specific protocols
 * - Player implementations for specific Content Types
 * - Type checkers for specific Content Types
 *
 */
public class SupportDatabase implements MediaConstants {

	public final static boolean JSR075Supported = false;

	static Hashtable gSupportTable;
	static Hashtable gPlayers;
	static Vector gTypeCheckers;

	static {
		//Register the supported types for protocols here
		String[] deviceContentTypes = new String[] { MIME_TYPE_TONE };
		String[] httpContentTypes = new String[]{
			MIME_TYPE_WAVE,
			MIME_TYPE_TONE,
			MIME_TYPE_MIDI
		};
		String[] fileContentTypes = new String[] {
			MIME_TYPE_WAVE,
			MIME_TYPE_TONE,
			MIME_TYPE_MIDI
		};
		String[] httpsContentTypes = new String[]{
			MIME_TYPE_WAVE,
			MIME_TYPE_TONE,
			MIME_TYPE_MIDI
		};

		gSupportTable = new Hashtable(4);
		gSupportTable.put(PROTOCOL_DEVICE,deviceContentTypes);
		gSupportTable.put(PROTOCOL_HTTP,httpContentTypes);
		gSupportTable.put(PROTOCOL_HTTPS,httpsContentTypes);
		gSupportTable.put(PROTOCOL_FILE,fileContentTypes);

		//Register your players here
		gPlayers = new Hashtable(3);
		gPlayers.put(MIME_TYPE_MIDI, "com.ibm.microedition.media.MIDIPlayer");
		gPlayers.put(MIME_TYPE_WAVE, "com.ibm.microedition.media.WAVPlayer");
		gPlayers.put(MIME_TYPE_TONE, "com.ibm.microedition.media.ToneSequencePlayer");

		//Register your content type checkers here
		gTypeCheckers = new Vector(4);
		gTypeCheckers.addElement(new WavContentTypeChecker());
		gTypeCheckers.addElement(new MidiContentTypeChecker());
		gTypeCheckers.addElement(new ToneSeqContentTypeChecker());
		gTypeCheckers.addElement(new DefaultTypeChecker());
	}

	public static Hashtable getSupportTable() {
		return gSupportTable;
	}

	public static Hashtable getPlayers() {
		return gPlayers;
	}

	public static Vector getTypeCheckers() {
		return gTypeCheckers;
	}
}
