package com.ibm.microedition.media.control;

/*
 *
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import javax.microedition.media.*;
import javax.microedition.media.control.*;
import com.ibm.microedition.media.*;

/**
 * VolumeControl implementation.
 * Events can be posted from this class or handled by the player.
 *
 */
public class VolumeCtrl implements VolumeControl {

	int volumeLevel = -1;
	private boolean muted = false;
	private boolean setLevelCalled = false;
	private MediaPlayer player;

	public VolumeCtrl(MediaPlayer player) {
		this.player = player;
//		volumeLevel = player.getVolumeLevelImpl();
	}

	public int getLevel() {
		if ((player.getState() == Player.REALIZED) && !setLevelCalled) return -1;

		// If the user hasn't set the volume, return the default player volume
		return volumeLevel == -1 ? player.getVolumeLevelImpl() : volumeLevel;
	}

	public boolean isMuted() {
		return muted;
	}

	public int setLevel(int level) {
		if (level < 0) {
			level = 0;
		} else if (level > 100) {
			level = 100;
		}
		if (level != volumeLevel) {
			volumeLevel = player.setVolumeLevelImpl(level);
			MediaEventManager.postEventVolumeControl(player, PlayerListener.VOLUME_CHANGED, this);
		}
		setLevelCalled = true;
		return volumeLevel;
	}

	public void setMute(boolean mute) {
		if (mute ^ muted) {
			if (mute) {
				player.setVolumeLevelImpl(0);
			} else {
				player.setVolumeLevelImpl(volumeLevel);
			}
			muted = mute;
			MediaEventManager.postEventVolumeControl(player, PlayerListener.VOLUME_CHANGED, this);
		}
	}
}
