package com.ibm.microedition.media.typechecker;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.*;
import java.util.Vector;
import com.ibm.microedition.media.*;

public abstract class AbstractTypeChecker implements MediaConstants
{
	private AbstractTypeChecker nextChecker;

	public void setNextChecker(AbstractTypeChecker nextChecker)
	{
		this.nextChecker = nextChecker;
	}

	/**
	* Calls the checkers to check content type of a MediaDescriptor
	* @param fullFileName
	* @return MIME TYPE of the media type
	*/
	public final String checkContentType(MediaDescriptor md) throws IOException {
		String contentType = check(md);
		if ((nextChecker != null) & (contentType==null) )
		{
			contentType = nextChecker.checkContentType(md);
		}
		return contentType;
	}

	public static AbstractTypeChecker createContentTypeCheckerChain() {

		Vector checkers=SupportDatabase.getTypeCheckers();
		AbstractTypeChecker checkerChainRoot=null;
		AbstractTypeChecker chainElement;
		AbstractTypeChecker currentElement;

		if (checkerChainRoot == null)
		{
			//register the checkers in the chain
			chainElement = (AbstractTypeChecker) checkers.elementAt(0);
			checkerChainRoot=chainElement;
			for (int t=1;t<checkers.size();t++)
			{
				currentElement = (AbstractTypeChecker) checkers.elementAt(t);
				chainElement.setNextChecker(currentElement);
				chainElement=currentElement;
			}
		}
		return checkerChainRoot;
	}

//	String getProtocol(MediaDescriptor mediaDescriptor)
//	{
//		mediaDescriptor.
//		String locator = dataSource.getLocator();
//		int index = locator.indexOf(':');
//		if(-1 == index) return null;
//		return(locator.substring(0,index));
//	}

	/**
	 *  Needs to be implemented in the subclasses
	 */
	public abstract String check(MediaDescriptor mediaDescriptor) throws IOException;

}
