package com.ibm.microedition.media.typechecker;

/*
 *
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.*;
import com.ibm.microedition.media.MediaDescriptor;

public class MidiContentTypeChecker extends AbstractTypeChecker {

	public String check(MediaDescriptor md) throws IOException {
		String protocol = md.getProtocol();
		if (protocol == null) return null;

		if (protocol.equals(PROTOCOL_FILE)) {
			byte[] header = new byte[4];
			byte[] mediaDescriptorHeader = md.getHeader();
			int headerLength = 0;
			if (mediaDescriptorHeader != null) {
				headerLength = mediaDescriptorHeader.length;
				if (headerLength > 4 ) {
					header = new byte[mediaDescriptorHeader.length];
				}
				System.arraycopy(mediaDescriptorHeader, 0, header, 0, headerLength);
			}

			if (headerLength < 4) {
				InputStream is = md.getMediaIS();
				do {
					int partialRead = is.read(header, headerLength, 4 - headerLength);
					if (partialRead < 0) break;

					headerLength += partialRead;
				} while (headerLength < 4);
			}

			md.setHeader(header);
			if ((header[0]== 77)
				&& (header[1]== 84)
				&& (header[2]== 104)
				&& (header[3]== 100) )
			{
				return MIME_TYPE_MIDI;
			}
		} else if (protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS)) {
			String contentType = md.getHttpContentType();
			if (contentType != null && contentType.equals(MIME_TYPE_MIDI)) return MIME_TYPE_MIDI;
	   	}
		return null;
	}
}
