package com.ibm.microedition.media.typechecker;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2004, 2005  All Rights Reserved
 */

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.media.control.ToneControl;

import com.ibm.microedition.media.MediaDescriptor;

/**
 * Validator for Tone Sequence files
 */
public class ToneSeqContentTypeChecker extends AbstractTypeChecker {

	public String check(MediaDescriptor md) throws IOException
	{
		String protocol = md.getProtocol();
		if (protocol == null) return null;

		if (protocol.equals(PROTOCOL_FILE))
		{
			byte[] header = new byte[4];
			byte[] mediaDescriptorHeader = md.getHeader();
			int headerLength = 0;
			if (mediaDescriptorHeader != null) {
				headerLength = mediaDescriptorHeader.length;
				if (headerLength > 2 ) {
					header = new byte[mediaDescriptorHeader.length];
				}
				System.arraycopy(mediaDescriptorHeader, 0, header, 0, headerLength);
			}

			if (headerLength < 2) {
				InputStream is = md.getMediaIS();
				do {
					int partialRead = is.read(header, headerLength, 4 - headerLength);
					if (partialRead < 0) break;

					headerLength += partialRead;
				} while (headerLength < 4);
			}
			md.setHeader(header);

			if (header[0]  == ToneControl.VERSION &&
				header[1]  == 0x01 )
				{
					return MIME_TYPE_TONE;
				}
		} else if (protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS)) {
			String contentType = md.getHttpContentType();
			if (contentType != null && contentType.equals(MIME_TYPE_TONE)) return MIME_TYPE_TONE;
		}

		return null;
	}
}
