package com.ibm.oti.connection.http;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

import java.util.Hashtable;
import java.util.Vector;

/**
 * The general structure for request / reponse header. It is essentially constructed by
 * hashtable with key indexed in a vector for position lookup.
 *
 * @author		OTI
 * @version		initial
 */

public class Header {
	/**
	 * The default amount of fields for a header
	 */
	private static final int incCapacity = 5;
	private Vector props = new Vector(incCapacity);
	private Hashtable keyTable = new Hashtable(incCapacity);
	private boolean duplicates = false;

/**
 * A generic header structure. Used mostly for request / response header.
 * The key/value pair of the header may be inserted for later use. The key
 * is stored in an array for indexed slot access.
 *
 * @author		OTI
 * @version		initial
 *
 */
public Header(boolean duplicates) {
	this.duplicates = duplicates;
}

/**
 * Add a field with the specified value.
 *
 * @author		OTI
 * @version		initial
 *
 * @param key java.lang.String
 * @param value java.lang.String
 */
public void add(String key, String value) {
	if (duplicates || keyTable.get(key) == null) {
		props.addElement(key);
		props.addElement(duplicates ? value : null);
	}
	if (key == null) keyTable.put(this, value);
	else keyTable.put(key.toLowerCase(), value);
}
/**
 * Answers the element at <code>pos</code>, null if no such element exist.
 *
 * @return java.lang.String		the value of the key
 * @param  pos	int				the position to look for
 */
public String get(int pos) {
	if (pos >= 0 && pos < props.size() / 2)
		return duplicates ?
			(String)props.elementAt(pos * 2 + 1) :
			get((String)props.elementAt(pos * 2));
	return null;
}
/**
 * Answers the value corresponding to the specified key, null if no such key exists.
 *
 * @author		OTI
 * @version		initial
 *
 * @return java.lang.String
 * @param key java.lang.String
 */
public String get(String key) {
	if (key == null) return (String)keyTable.get(this);
	return (String)keyTable.get(key.toLowerCase());
}
/**
 * Answers the key of this header at <code>pos</code>, null if there are fewer keys in the header
 *
 * @author		OTI
 * @version		initial
 *
 * @return java.lang.String		the key the desired position
 * @param pos int		the position to look for
 */
public String getKey(int pos) {
	if (pos >= 0 && pos < props.size() / 2)
		return (String)props.elementAt(pos * 2);
	return null;
}
/**
 * Answers the number of keys stored in this header
 *
 * @author		OTI
 * @version		initial
 *
 * @return int
 */
public int length() {
	return props.size() / 2;
}
}
