package com.ibm.oti.error;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2003  All Rights Reserved
 */

public class Error extends java.lang.Error {
	private static Hook hook;

public Error(String msg) {
	if (hook != null)
		hook.fatalError(this.getClass(), msg);

	String output = this.getClass().getName();
	int index = output.lastIndexOf('.');
	if (index != -1)
		output = output.substring(index + 1, output.length());
	if (msg != null)
		output = output + ": " + msg;
	new java.lang.Error(output).printStackTrace();
	com.ibm.oti.vm.VM.allowMidpExit();
	System.exit(1);
}

/**
 * Set the Hook instance which will be notified when a
 * fatal error occurs.
 *
 * @author		OTI
 * @version		initial
 */
public static void setHook(Hook value) {
	if (!com.ibm.oti.vm.VM.callerIsBootstrap())
		throw new SecurityException();
	hook = value;
}
}
