
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

package com.ibm.oti.security.provider;

/**
 * @author 		OTI
 * @version 	initial
 */
final class X509Extension {

	private ASN1OID id;				// The OID for this extension
	private byte[] value;			// The value for this extension
	private boolean isCritical;		// If this extension is critical or not

/**
 * Constructs a new instance of this class
 *
 * @param id	The ASN.1 OID from which to create an instance
 * @param value	The actual value for the extension
 * @param isCritical	If this extension is critical or not
 */
public X509Extension(ASN1OID id, byte[] value, boolean isCritical) {
	this.id = id;
	this.value = value;
	this.isCritical = isCritical;
}

/**
 * Generates a hash code for the receiver.
 * This method is supported primarily for
 * hash tables, such as those provided in java.util.
 * @return an integer hash code for the receiver
 * @see java.util.Hashtable
 */
public int hashCode() {
	return id.hashCode();
}

/**
 * Compares two objects for equality. Returns a boolean that indicates
 * whether this object is equivalent to the specified object. This method
 * is used when an object is stored in a hashtable.
 * @param obj the Object to compare with
 * @return true if these Objects are equal; false otherwise.
 * @see java.util.Hashtable
 */
public boolean equals(Object obj) {
	if (obj == null) return false;
	if (this == obj) return true;
	if ( ! (obj instanceof X509Extension) ) return false;

	X509Extension other = (X509Extension) obj;
	return this.id.equals (other.id);
}

/**
 * Answers a string containing a concise, human-readable
 * description of the receiver.
 *
 * @return		String
 *					a printable representation for the receiver.
 */
public String toString() {
	return id.toString() + "->" + value;
}

/**
 * Answers a boolean indicating whether the receiver is a critical extension or not
 *
 * @return		true if the receiver is a critical extension, false otherwise
 */
public boolean isCritical() {
	return isCritical;
}

/**
 * Return the actual extension value
 *
 * @return		byte[], the actual extension value
 */
public byte[] value() {
	return value;
}

/**
 * Return the name of this extension
 *
 * @return		String, the name of this extension
 */
public String name() {
	int[] representation = id.representation();
	StringBuffer result = new StringBuffer();
	for (int i = 0; i < representation.length-1; i++) {
		result.append (representation[i]);
		result.append ('.');
	}
	result.append (representation[representation.length-1]);
	return result.toString();
}

}
