package com.ibm.oti.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

import java.util.*;

/**
 * The SystemProperties interface is used to manipulate system properties
 * on JCL startup. The system property com.ibm.util.extralibs.properties
 * is parsed (in the form "ext1[:ext2]") and bootstrap classes in the form
 * com.ibm.oti.ext1.SystemPropertyExtension are loaded, instantiated, and
 * sent extendSystemProperties(). The system property
 * com.ibm.util.extralibs.properties is set by the vm when specified using
 * the -jcl: option. i.e. -jcl:foun10:ext1[:ext2]
 *
 * @deprecated use SystemPropertiesHook
 */
public interface SystemProperties {

	/**
	 * Called on JCL startup.
	 *
	 * @param properties the system property table
	 */
	public void extendSystemProperties(Hashtable properties);
}
