
package java.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

/**
 * This IO exception is thrown when a program reading or writing
 * to a stream is interrupted.  This is also thrown when a socket
 * timeout occurs before the request has completed.
 *
 * @author		OTI
 * @version		initial
 */
public class InterruptedIOException extends IOException {

	/**
	 * The number of bytes transferred before the IO interrupt
	 * occurred.  The default is 0 but the value may be filled
	 * in by the caller of the constructor.
	 */
	public int bytesTransferred;

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public InterruptedIOException () {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage	The detail message for the exception.
 */
public InterruptedIOException (String detailMessage) {
	super(detailMessage);
}

}
