
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

/**
 * This runtime exception is thrown when the an array
 * is indexed with a value less than zero, or greater
 * than or equal to the size of the array.
 *
 * @author		OTI
 * @version		initial
 */
public class ArrayIndexOutOfBoundsException extends IndexOutOfBoundsException {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public ArrayIndexOutOfBoundsException () {
	super();
}

/**
 * Constructs a new instance of this class with its walkback
 * and message (which is based on the argument which is the
 * index which failed) filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		index int
 *				the offending index.
 */
public ArrayIndexOutOfBoundsException (int index) {
	// K0052 = Array index out of range: {0}
	super(com.ibm.oti.util.Msg.getString("K0052", index));
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public ArrayIndexOutOfBoundsException (String detailMessage) {
	super(detailMessage);
}

}
