package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * Booleans are objects (i.e. non-base types) which represent
 * boolean values.
 *
 * @author		OTI
 * @version		initial
 */
public final class Boolean {

	/**
	 * The boolean value of the receiver.
	 */
	private final boolean value;

	/**
	 * The instance of the receiver which represents truth.
	 */
	public static final Boolean TRUE = new Boolean(true);

	/**
	 * The instance of the receiver which represents falsehood.
	 */
	public static final Boolean FALSE = new Boolean(false);

/**
 * Constructs a new instance of this class given true or false.
 *
 * @param		value		true or false.
 */
public Boolean (boolean value) {
	this.value = value;
}
/**
 * Answers true if the receiver represents true and
 * false if the receiver represents false.
 *
 * @return		true or false.
 */
public boolean booleanValue () {
	return value;
}
/**
 * Compares the argument to the receiver, and answers true
 * if they represent the <em>same</em> object using a class
 * specific comparison.
 * <p>
 * In this case, the argument must also be a Boolean, and
 * the receiver and argument must represent the same boolean
 * value (i.e. both true or both false).
 *
 * @param		o			the object to compare with this object
 * @return		<code>true</code> if the object is the same as this object
 *				<code>false</code> if it is different from this object
 *
 * @see			#hashCode
 */
public boolean equals (Object o) {
	return (o == this) ||
		((o instanceof Boolean) && (value == ((Boolean) o).value));
}

/**
 * Answers an integer hash code for the receiver. Any two
 * objects which answer <code>true</code> when passed to
 * <code>equals</code> must answer the same value for this
 * method.
 *
 * @return		the receiver's hash
 *
 * @see			#equals
 */
public int hashCode() {
	return value ? 1231 : 1237;
}
/**
 * Answers a string containing a concise, human-readable
 * description of the receiver.
 *
 * @return		a printable representation for the receiver.
 */
public String toString () {
	return String.valueOf(value);
}

}
