
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * This class is the superclass of all classes which
 * represent unrecoverable errors. When Errors are thrown,
 * they should not be caught by application code.
 *
 * @author		OTI
 * @version		initial
 *
 * @see			Throwable
 * @see			Exception
 * @see			RuntimeException
 */
public class Error extends Throwable {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public Error () {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public Error (String detailMessage) {
	super(detailMessage);
}

}
