
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * This runtime exception is thrown when a monitor
 * operation is attempted when the monitor is not in the
 * correct state, for example when a thread attempts
 * to exit a monitor which it did not own.
 *
 * @author		OTI
 * @version		initial
 */
public class IllegalMonitorStateException extends RuntimeException {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public IllegalMonitorStateException () {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public IllegalMonitorStateException (String detailMessage) {
	super(detailMessage);
}

}
