
package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2002  All Rights Reserved
 */

/**
 * This error is thrown when a request is made for more
 * memory either as a result of the running program, or
 * because of the internal behavior of the virtual machine
 * which can not be satisfied using the available platform
 * resources.
 *
 * @author		OTI
 * @version		initial
 */
public class OutOfMemoryError extends java.lang.VirtualMachineError {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public OutOfMemoryError() {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public OutOfMemoryError(String detailMessage) {
	super(detailMessage);
}

}
