package java.lang;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * The Runtime interface.
 */

public class Runtime {
	// single instance of Runtime class.
	private static final Runtime runtime = new Runtime();
/**
 * Prevent instantiation with private constructor
 */
private Runtime() {
}

/**
 * Causes the virtual machine to stop running, and the
 * program to exit. If runFinalizersOnExit(true) has been
 * invoked, then all finalizers will be run first.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		code		the return code.
 *
 * @exception	SecurityException
 *							if the running thread is not allowed
 *							to cause the vm to exit.
 *
 * @see			SecurityManager#checkExit
 */
public void exit (int code) {
	if (!com.ibm.oti.vm.VM.allowExit())
		// K01b5 = Cannot use exit(), use MIDlet.notifyDestroyed()
		throw new SecurityException(com.ibm.oti.util.Msg.getString("K01b5"));
	exitImpl(code);
}

private native void exitImpl(int code);

/**
 * Answers the amount of free memory resources which
 * are available to the running program.
 *
 * @author		OTI
 * @version		initial
 */
public native long freeMemory();

/**
 * Indicates to the virtual machine that it would be a
 * good time to collect available memory. Note that, this
 * is a hint only.
 *
 * @author		OTI
 * @version		initial
 */
public native void gc();
/**
 * Return the single Runtime instance
 *
 * @author		OTI
 * @version		initial
 */
public static Runtime getRuntime(){
	return runtime;
}

/**
 * Answers the total amount of memory resources which
 * is available to (or in use by) the running program.
 *
 * @author		OTI
 * @version		initial
 */
public native long totalMemory();

}
