
package java.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

/**
 * This runtime exception is thrown when trying to
 * retrieve an element past the end of an Enumeration,
 * or the first or last element from an empty Vector.
 *
 * @author		OTI
 * @version		initial
 *
 * @see		Enumeration
 * @see		java.lang.RuntimeException
 */
public class NoSuchElementException extends RuntimeException {

/**
 * Constructs a new instance of this class with its
 * walkback filled in.
 *
 * @author		OTI
 * @version		initial
 */
public NoSuchElementException () {
	super();
}

/**
 * Constructs a new instance of this class with its
 * walkback and message filled in.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage String
 *				The detail message for the exception.
 */
public NoSuchElementException (String detailMessage) {
	super(detailMessage);
}

}
