package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2005  All Rights Reserved
 */

import java.io.IOException;

public interface DatagramConnection extends Connection {

public int getMaximumLength() throws IOException;
public int getNominalLength() throws IOException;
public Datagram newDatagram(byte[] data, int length) throws IOException;
public Datagram newDatagram(byte[] data, int length, String address) throws IOException;
public Datagram newDatagram(int length) throws IOException;
public Datagram newDatagram(int length, String address) throws IOException;
public void receive(Datagram datagram) throws IOException;
public void send(Datagram datagram) throws IOException;

}
